<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../../config/db_add.php';

function logError($message) {
    file_put_contents(__DIR__ . '/upload_errors.log', date('Y-m-d H:i:s') . " - " . $message . "\n", FILE_APPEND);
}

if ($conn->connect_error) {
    logError("Connection failed: " . $conn->connect_error);
    die("Connection failed: " . $conn->connect_error);
}

$title = $_POST['title'];
$description = $_POST['description'];
$code = $_POST['code'];
$mode = $_POST['mode'];
$start_date = $_POST['start_date'];
$end_date = $_POST['end_date'];
$fee_amount = $_POST['fee_amount'];
$is_fullTime = $_POST['is_fullTime'];
$location = $_POST['location'];
$mentorId = $_POST['mentorId'];
$isCourse = "1";

// Prepare SQL statement
$sql = "INSERT INTO trainings (title, description, code, isCourse, mode, start_date, end_date, fee_amount, is_fullTime, location, mentorId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    logError("Prepare statement failed: " . $conn->error);
    die("Prepare statement failed: " . $conn->error);
}

$stmt->bind_param('sssisssssss', $title, $description, $code, $isCourse, $mode, $start_date, $end_date, $fee_amount, $is_fullTime, $location, $mentorId);

if ($stmt->execute()) {
    $courseId = $stmt->insert_id; // Get the inserted course ID

    // Handle file upload
    if (isset($_FILES['courseImage'])) {
        if ($_FILES['courseImage']['error'] === UPLOAD_ERR_OK) {
            $uploadDir = '/home/trultwik/mobile_app_backend/uploads/training_images/';
            $uploadFile = $uploadDir . $courseId . '.jpeg';

            // Check if the directory is writable
            if (is_writable($uploadDir)) {
                if (move_uploaded_file($_FILES['courseImage']['tmp_name'], $uploadFile)) {
                    echo json_encode(['success' => true, 'message' => 'Course added and image uploaded successfully.']);
                } else {
                    logError("Failed to move uploaded file.");
                    echo json_encode(['success' => true, 'message' => 'Course added, but failed to upload image.']);
                }
            } else {
                logError("Upload directory is not writable.");
                echo json_encode(['success' => true, 'message' => 'Course added, but upload directory is not writable.']);
            }
        } else {
            logError("File upload error: " . $_FILES['courseImage']['error']);
            echo json_encode(['success' => true, 'message' => 'Course added, but file upload error occurred.']);
        }
    } else {
        logError("courseImage not set in \$_FILES.");
        echo json_encode(['success' => true, 'message' => 'Course added, but no image uploaded.']);
    }
} else {
    logError("Execute statement failed: " . $stmt->error);
    echo json_encode(['success' => false, 'message' => 'Failed to add course.']);
}

$stmt->close();
$conn->close();
?>
