<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}


require_once __DIR__ . '/../../config/db_add.php';


if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}


$name = $_POST['name'];
$content = $_POST['content'];
$type = $_POST['type'];


$targetDir = "./uploads/res/arti/";
$targetFile = $targetDir . basename($_FILES["file"]["name"]);
$uploadOk = 1;
$fileType = strtolower(pathinfo($targetFile,PATHINFO_EXTENSION));

if($fileType != "pdf" ) {
    echo json_encode(['status' => 'error', 'message' => 'Only PDF files are allowed.']);
    $uploadOk = 0;
}

// Check if $uploadOk is set to 0 by an error
if ($uploadOk == 0) {
    echo json_encode(['status' => 'error', 'message' => 'File was not uploaded.']);
// If everything is ok, try to upload file
} else {
    if (move_uploaded_file($_FILES["file"]["tmp_name"], $targetFile)) {
        // Prepare the SQL statement
        $stmt = $conn->prepare("INSERT INTO resources (name, content, type, path, createdAt) VALUES (?, ?, ?, ?, NOW())");
        $stmt->bind_param("ssss", $name, $content, $type, $targetFile);

        // Execute the statement
        if ($stmt->execute()) {
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => $stmt->error]);
        }

        // Close the statement and connection
        $stmt->close();
    } else {
        echo json_encode(['status' => 'error', 'message' => 'There was an error uploading your file.']);
    }
}

$conn->close();
?>