<?php

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database configuration
require_once __DIR__ . '/../../config/db_add.php';

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get request parameters
$fromDate = isset($_GET['fromDate']) ? $_GET['fromDate'] : '';
$toDate = isset($_GET['toDate']) ? $_GET['toDate'] : '';
$courseStatus = isset($_GET['courseStatus']) ? $_GET['courseStatus'] : '';
$trainingTitle = isset($_GET['trainingTitle']) ? $_GET['trainingTitle'] : '';

// Prepare base query
$query = "
    SELECT 
        users.id AS user_id,
        users.name AS user_name,
        users.email AS user_email,
        users.role AS user_role,
        users.phonenumber AS user_phonenumber,
        users.password AS user_password,
        users.level AS user_level,
        users.location AS user_location,
        users.contact_details AS user_contact_details,
        users.qualification AS user_qualification,
        users.date_of_birth AS user_date_of_birth,
        users.age AS user_age,
        users.gender AS user_gender,
        users.permanent_address AS user_permanent_address,
        users.community AS user_community,
        users.religion AS user_religion,
        users.differently_abled AS user_differently_abled,
        users.name_of_university AS user_name_of_university,
        users.name_of_degree AS user_name_of_degree,
        users.year_of_completion AS user_year_of_completion,
        users.percentage_of_marks AS user_percentage_of_marks,
        users.father_name AS user_father_name,
        users.mother_name AS user_mother_name,
        users.guardian_number AS user_guardian_number,
        users.address_of_communication AS user_address_of_communication,
        users.pincode AS user_pincode
    FROM 
        users
    WHERE 1=1
";
// Apply filters if provided
if ($fromDate || $toDate || $courseStatus !== '' || $trainingTitle) {
    $query .= "
        AND EXISTS (
            SELECT 1
            FROM userCourses
            JOIN trainings ON userCourses.trainingId = trainings.id
            WHERE userCourses.userid = users.id";
    if ($fromDate) {
        $query .= " AND userCourses.createdAt >= '" . $conn->real_escape_string($fromDate) . "'";
    }
    if ($toDate) {
        $query .= " AND userCourses.createdAt <= '" . $conn->real_escape_string($toDate) . "'";
    }
    if ($courseStatus !== '') {
        $query .= " AND userCourses.is_course_completed = '" . ($courseStatus == 'completed' ? 1 : 0) . "'";
    }
    if ($trainingTitle) {
        $query .= " AND trainings.title = '" . $conn->real_escape_string($trainingTitle) . "'";
    }
    $query .= ")";
}

// Apply pagination
$query .= " ORDER BY users.id DESC";

// Get the total number of records (for pagination)
$totalQuery = "
    SELECT COUNT(*) AS total
    FROM users
    WHERE 1=1
";

if ($fromDate || $toDate || $courseStatus !== '' || $trainingTitle) {
    $totalQuery .= "
        AND EXISTS (
            SELECT 1
            FROM userCourses
            JOIN trainings ON userCourses.trainingId = trainings.id
            WHERE userCourses.userid = users.id";
    if ($fromDate) {
        $totalQuery .= " AND userCourses.createdAt >= '" . $conn->real_escape_string($fromDate) . "'";
    }
    if ($toDate) {
        $totalQuery .= " AND userCourses.createdAt <= '" . $conn->real_escape_string($toDate) . "'";
    }
    if ($courseStatus !== '') {
        $totalQuery .= " AND userCourses.is_course_completed = '" . ($courseStatus == 'completed' ? 1 : 0) . "'";
    }
    if ($trainingTitle) {
        $totalQuery .= " AND trainings.title = '" . $conn->real_escape_string($trainingTitle) . "'";
    }
    $totalQuery .= ")";
}

$totalResult = $conn->query($totalQuery);
$totalRecords = $totalResult->fetch_assoc()['total'];

// Execute the main query
$result = $conn->query($query);

$data = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Output in DataTables format
$response = [
    "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $totalRecords,
    "data" => $data
];

echo json_encode($response);
$conn->close();
?>
