<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database configuration
require_once __DIR__ . '/../../config/db_add.php';

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get request parameters
$fromDate = isset($_GET['fromDate']) ? $_GET['fromDate'] : '';
$toDate = isset($_GET['toDate']) ? $_GET['toDate'] : '';
$rating = isset($_GET['rating']) ? $_GET['rating'] : '';
$userId = isset($_GET['userId']) ? $_GET['userId'] : '';

// Prepare base query
$query = "
    SELECT 
        users.id AS user_id,
        users.name AS user_name,
        users.email AS user_email,
        users.role AS user_role,
        users.phonenumber AS user_phonenumber,
        users.level AS user_level,
        users.location AS user_location,
        feedback.rating AS feedback_rating,
        feedback.description AS feedback_description,
        feedback.createdAt AS feedback_createdAt
    FROM 
        feedback
    JOIN 
        users ON feedback.userId = users.id
    WHERE 1=1
";

// Apply filters if provided
if ($fromDate) {
    $query .= " AND feedback.createdAt >= '" . $conn->real_escape_string($fromDate) . "'";
}
if ($toDate) {
    $query .= " AND feedback.createdAt <= '" . $conn->real_escape_string($toDate) . "'";
}
if ($rating !== '') {
    $query .= " AND feedback.rating = '" . $conn->real_escape_string($rating) . "'";
}
if ($userId) {
    $query .= " AND feedback.userId = '" . $conn->real_escape_string($userId) . "'";
}

// Get the total number of records (for pagination)
$totalQuery = "
    SELECT COUNT(*) AS total
    FROM feedback
    JOIN users ON feedback.userId = users.id
    WHERE 1=1
";

if ($fromDate) {
    $totalQuery .= " AND feedback.createdAt >= '" . $conn->real_escape_string($fromDate) . "'";
}
if ($toDate) {
    $totalQuery .= " AND feedback.createdAt <= '" . $conn->real_escape_string($toDate) . "'";
}
if ($rating !== '') {
    $totalQuery .= " AND feedback.rating = '" . $conn->real_escape_string($rating) . "'";
}
if ($userId) {
    $totalQuery .= " AND feedback.userId = '" . $conn->real_escape_string($userId) . "'";
}

$totalResult = $conn->query($totalQuery);
$totalRecords = $totalResult->fetch_assoc()['total'];

// Execute the main query
$result = $conn->query($query);

$data = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Output in DataTables format
$response = [
    "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $totalRecords,
    "data" => $data
];

echo json_encode($response);
$conn->close();
?>
