<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database configuration
require_once __DIR__ . '/../../config/db_add.php';

ob_clean();

$response = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = isset($_POST['email']) ? trim($_POST['email']) : null;
    $password = isset($_POST['password']) ? trim($_POST['password']) : null;

    $stmt = $conn->prepare("SELECT * FROM admin_users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        if (password_verify($password, $user['password'])) {
            $_SESSION['user'] = $user;
            $response['status'] = 'success';
            $response['user_email'] = $user['email'];
         
            $app_no = $user['email'];
            $encryptedAppNo = base64_encode($app_no);

            // Store encrypted app_no in session
            $_SESSION['user_email'] = $encryptedAppNo;
            $_SESSION['user_role'] = $user['role'];
        } else {
            $response['status'] = 'error2';
        }
    } else {
        $response['status'] = 'error1';
    }

    $stmt->close();
} else {
    $response['status'] = 'error';
}

header('Content-Type: application/json');
echo json_encode($response);
$conn->close();
?>
