<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database configuration
require_once __DIR__ . '/../../config/db_add.php';

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the role parameter from the GET request
$role = isset($_GET['role']) ? $_GET['role'] : '';

// Construct the SQL query
$sql = "SELECT id, name, role, email, phonenumber, qualification, location FROM users WHERE role IN ('mentor', 'expert', 'investor')";

// Add filter if role is specified
if (!empty($role)) {
    $sql .= " AND role = '" . $conn->real_escape_string($role) . "'";
}

// Execute the query
$result = $conn->query($sql);

// Prepare the data array
$data = array();

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Close the database connection
$conn->close();

// Return the data as JSON
echo json_encode(array("data" => $data));
?>
