<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database configuration
require_once __DIR__ . '/../../config/db_add.php';

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get filter parameters
$name = isset($_GET['name']) ? $conn->real_escape_string($_GET['name']) : '';
$type = isset($_GET['type']) ? $conn->real_escape_string($_GET['type']) : '';
$fromDate = isset($_GET['fromDate']) ? $conn->real_escape_string($_GET['fromDate']) : '';
$toDate = isset($_GET['toDate']) ? $conn->real_escape_string($_GET['toDate']) : '';

// Pagination variables
$limit = isset($_GET['length']) ? intval($_GET['length']) : 10;
$offset = isset($_GET['start']) ? intval($_GET['start']) : 0;

// Base query
$query = "SELECT id, name, content, type, path, createdAt, updatedAt FROM resources WHERE 1=1";

// Apply filters if provided
if ($name) {
    $query .= " AND name LIKE '%$name%'";
}
if ($type) {
    $query .= " AND type = '$type'";
}
if ($fromDate) {
    $query .= " AND createdAt >= '$fromDate'";
}
if ($toDate) {
    $query .= " AND createdAt <= '$toDate'";
}

// Get the total number of filtered records
$totalQuery = "SELECT COUNT(*) AS total FROM resources WHERE 1=1";
if ($name) {
    $totalQuery .= " AND name LIKE '%$name%'";
}
if ($type) {
    $totalQuery .= " AND type = '$type'";
}
if ($fromDate) {
    $totalQuery .= " AND createdAt >= '$fromDate'";
}
if ($toDate) {
    $totalQuery .= " AND createdAt <= '$toDate'";
}
$totalResult = $conn->query($totalQuery);
$totalRecords = $totalResult->fetch_assoc()['total'];

// Apply pagination
$query .= " LIMIT $offset, $limit";

// Execute the main query
$result = $conn->query($query);

$data = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Output in DataTables format
$response = [
    "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $totalRecords,
    "data" => $data
];

echo json_encode($response);
$conn->close();
?>
