<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database configuration
require_once __DIR__ . '/../../config/db_add.php';

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get request parameters
$fromDate = isset($_GET['fromDate']) ? $_GET['fromDate'] : '';
$toDate = isset($_GET['toDate']) ? $_GET['toDate'] : '';
$courseStatus = isset($_GET['courseStatus']) ? $_GET['courseStatus'] : '';
$trainingTitle = isset($_GET['trainingTitle']) ? $_GET['trainingTitle'] : '';
$location = isset($_GET['location']) ? $_GET['location'] : '';

// Prepare base query
$query = "
    SELECT 
        trainings.id AS training_id,
        trainings.title AS training_title,
        trainings.description AS training_description,
        trainings.code AS training_code,
        trainings.isCourse AS training_isCourse,
        trainings.mode AS training_mode,
        trainings.rating AS training_rating,
        trainings.start_date AS training_start_date,
        trainings.end_date AS training_end_date,
        trainings.fee_amount AS training_fee_amount,
        trainings.is_fullTime AS training_is_fullTime,
        trainings.location AS training_location,
        trainings.mentorId AS training_mentorId,
        trainings.createdAt AS training_createdAt,
        trainings.updatedAt AS training_updatedAt
    FROM 
        trainings
    WHERE 1=1
";

// Apply filters if provided
if ($fromDate) {
    $query .= " AND trainings.start_date >= '" . $conn->real_escape_string($fromDate) . "'";
}
if ($toDate) {
    $query .= " AND trainings.end_date <= '" . $conn->real_escape_string($toDate) . "'";
}
if ($courseStatus !== '') {
    $query .= " AND trainings.isCourse = '" . ($courseStatus == 'completed' ? 1 : 0) . "'";
}
if ($trainingTitle) {
    $query .= " AND trainings.title LIKE '%" . $conn->real_escape_string($trainingTitle) . "%'";
}
if ($location) {
    $query .= " AND trainings.location = '" . $conn->real_escape_string($location) . "'";
}
// No pagination: Fetch all records
// $limit = isset($_GET['length']) ? intval($_GET['length']) : 10;
// $offset = isset($_GET['start']) ? intval($_GET['start']) : 0;

// Apply pagination (commented out)
$query .= " ORDER BY trainings.createdAt DESC";

// Get the total number of records (for pagination)
$totalQuery = "
    SELECT COUNT(*) AS total
    FROM trainings
    WHERE 1=1
";

if ($fromDate) {
    $totalQuery .= " AND trainings.start_date >= '" . $conn->real_escape_string($fromDate) . "'";
}
if ($toDate) {
    $totalQuery .= " AND trainings.end_date <= '" . $conn->real_escape_string($toDate) . "'";
}
if ($courseStatus !== '') {
    $totalQuery .= " AND trainings.isCourse = '" . ($courseStatus == 'completed' ? 1 : 0) . "'";
}
if ($trainingTitle) {
    $totalQuery .= " AND trainings.title LIKE '%" . $conn->real_escape_string($trainingTitle) . "%'";
}
if ($location) {
    $totalQuery .= " AND trainings.location = '" . $conn->real_escape_string($location) . "'";
}

$totalResult = $conn->query($totalQuery);
$totalRecords = $totalResult->fetch_assoc()['total'];

// Execute the main query
$result = $conn->query($query);

$data = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Output in DataTables format
$response = [
    "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $totalRecords,
    "data" => $data
];

echo json_encode($response);
$conn->close();
?>
