<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database configuration
require_once __DIR__ . '/../../config/db_add.php';

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get data from form submission
$id = isset($_POST['id']) ? $_POST['id'] : null;
$title = isset($_POST['title']) ? $_POST['title'] : null;
$description = isset($_POST['description']) ? $_POST['description'] : null;
$code = isset($_POST['code']) ? $_POST['code'] : null;
$mode = isset($_POST['mode']) ? $_POST['mode'] : null;
$start_date = isset($_POST['start_date']) ? $_POST['start_date'] : null;
$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : null;
$fee_amount = isset($_POST['fee_amount']) ? $_POST['fee_amount'] : null;
$is_fullTime = isset($_POST['is_fullTime']) ? $_POST['is_fullTime'] : null;
$location = isset($_POST['location']) ? $_POST['location'] : null;
$mentorId = isset($_POST['mentorId']) ? $_POST['mentorId'] : null;

// Prepare and bind for updating course details
$stmt = $conn->prepare("UPDATE trainings SET title = ?, description = ?, code = ?, mode = ?, start_date = ?, end_date = ?, fee_amount = ?, is_fullTime = ?, location = ?, mentorId = ?, updatedAt = NOW() WHERE id = ?");
$stmt->bind_param("sssssssissi", $title, $description, $code, $mode, $start_date, $end_date, $fee_amount, $is_fullTime, $location, $mentorId, $id);

// Execute the statement for updating course details
if ($stmt->execute()) {
    // Check if an image file was uploaded
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = '/home/trultwik/mobile_app_backend/uploads/training_images/';
        $fileName = $id . '.jpeg'; // Assuming image is a PNG file
        $filePath = $uploadDir . $fileName;

        // Debugging: Check if file exists and path
        error_log("File path: " . $filePath);

        // Check if file already exists and delete it
        if (file_exists($filePath)) {
            unlink($filePath);
        }

        // Move uploaded file to target directory
        if (move_uploaded_file($_FILES['image']['tmp_name'], $filePath)) {
            echo json_encode(["status" => "success", "message" => "Training updated successfully!"]);
        } else {
            error_log("Failed to move uploaded file."); // Debugging
            echo json_encode(["status" => "error", "message" => "Failed to upload image."]);
        }
    } else {
        error_log("No image uploaded or upload error."); // Debugging
        echo json_encode(["status" => "success", "message" => "Training updated successfully, but no image uploaded."]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update training."]);
}

// Close statement and connection
$stmt->close();
$conn->close();
?>
