<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}


require_once __DIR__ . '/../../config/db_add.php';


if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = $_POST['id'];
$name = $_POST['name'];
$content = $_POST['content'];
$type = $_POST['type'];

if (!empty($_FILES['file']['name'])) {
    // Set the target directory based on the resource type
    if ($type == "Ebooks") {
        $targetDir = "./uploads/res/ebooks/";
    } else {
        $targetDir = "./uploads/res/arti/";
    }

    $targetFile = $targetDir . basename($_FILES["file"]["name"]);
    $uploadOk = 1;
    $fileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));


    if ($fileType != "pdf") {
        echo json_encode(['status' => 'error', 'message' => 'Only PDF files are allowed.']);
        $uploadOk = 0;
    }

    if ($uploadOk == 0) {
        echo json_encode(['status' => 'error', 'message' => 'File was not uploaded.']);
    } else {
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $targetFile)) {
            $stmt = $conn->prepare("UPDATE resources SET name = ?, content = ?, type = ?, path = ?, updatedAt = NOW() WHERE id = ?");
            $stmt->bind_param("ssssi", $name, $content, $type, $targetFile, $id);

            if ($stmt->execute()) {
                echo json_encode(['status' => 'success']);
            } else {
                echo json_encode(['status' => 'error', 'message' => $stmt->error]);
            }

            $stmt->close();
        } else {
            echo json_encode(['status' => 'error', 'message' => 'There was an error uploading your file.']);
        }
    }
} else {
    $stmt = $conn->prepare("UPDATE resources SET name = ?, content = ?, type = ?, updatedAt = NOW() WHERE id = ?");
    $stmt->bind_param("sssi", $name, $content, $type, $id);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => $stmt->error]);
    }

    $stmt->close();
}

$conn->close();
?>