<?php require_once("controllers/layout/header.php") ?>
<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <div class="container-fluid page-body-wrapper">
         <?php require_once("controllers/layout/sidebar.php") ?>
         <div class="main-panel">
            <div class="content-wrapper">
               <div class="row">
                  <div class="col-md-12 grid-margin">
                     <div class="row">
                        <div class="col-12 col-xl-8 mb-4 mb-xl-0">
                           <h3 class="font-weight-bold">Welcome Admin</h3>
                           <h6 class="font-weight-normal mb-0">All systems are running smoothly! Today is going to be <span class="text-primary"> Great Day!</span></h6>
                        </div>
                        <div class="col-12 col-xl-4">
                           <div class="justify-content-end d-flex">
                              <div class="dropdown flex-md-grow-1 flex-xl-grow-0">
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-md-6 grid-margin stretch-card">
                     <div class="card tale-bg">
                        <div class="card-people mt-auto">
                           <img src="./static/images/dashboard/people.png" alt="people">
                           <div class="weather-info">
                              <div class="d-flex">
                                 <div>
                                    <h2 class="mb-0 font-weight-normal">Today</h2>
                                 </div>
                                 <div class="ms-2">
                                    <h4 class="location font-weight-normal"><span id="currentDate">Good day</span></h4>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="col-md-6 grid-margin transparent">
                     <div class="row">
                        <div class="col-md-6 mb-4 stretch-card transparent">
                           <div class="card card-tale">
                              <div class="card-body">
                                 <p class="mb-4">Number of Application</p>
                                 <p class="fs-30 mb-2"><?php echo $applicationCount; ?></p>
                                 <p>All Courses Applications</p>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-6 mb-4 stretch-card transparent">
                           <div class="card card-dark-blue">
                              <div class="card-body">
                                 <p class="mb-4">Number of Trainings</p>
                                 <p class="fs-30 mb-2"><?php echo $trainingCount; ?></p>
                                 <p>All Trainings</p>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="row">
                        <div class="col-md-6 mb-4 mb-lg-0 stretch-card transparent">
                           <div class="card card-light-blue">
                              <div class="card-body">
                                 <p class="mb-4">Number of Mentors</p>
                                 <p class="fs-30 mb-2"><?php echo $mentorCount; ?></p>
                                 <p>Registered Mentors</p>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-6 stretch-card transparent">
                           <div class="card card-light-danger">
                              <div class="card-body">
                                 <p class="mb-4">Number of Candidates</p>
                                 <p class="fs-30 mb-2"><?php echo $candidateCount; ?></p>
                                 <p>Registered Candidates</p>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <script>
      document.addEventListener('DOMContentLoaded', (event) => {
          const currentDate = new Date();
          const options = { year: 'numeric', month: 'short', day: 'numeric' };
          const formattedDate = currentDate.toLocaleDateString('en-US', options);
      
          document.getElementById('currentDate').innerText = `Good day (${formattedDate})`;
      });
   </script>
   <script src="./static/vendors/js/vendor.bundle.base.js"></script>
   <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/vendors/datatables.net/jquery.dataTables.js"></script>
   <script src="./static/vendors/datatables.net-bs5/dataTables.bootstrap5.js"></script>
   <script src="./static/js/dataTables.select.min.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>