<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

   if (session_status() == PHP_SESSION_NONE) {
       session_start();
   }
   
   require_once __DIR__ . '/../../config/db_add.php';
   
   function sanitize_input($data) {
       return htmlspecialchars(strip_tags(trim($data)));
   }
   
   // // Function to check if session is expired
   // function check_session_timeout() {
   //     $inactive = 900; // Session timeout in seconds (15 minutes)
   //     if (isset($_SESSION['start_time'])) {
   //         $session_life = time() - $_SESSION['start_time'];
   //         if ($session_life > $inactive) {
   //             session_unset();
   //             session_destroy();
   //             header('Location: ../login');
   //             exit();
   //         }
   //     }
   //     $_SESSION['start_time'] = time(); // Update session start time
   // }
   
   // // Check session timeout
   // check_session_timeout();
   
   // Redirect to login if not authenticated
   if (!isset($_SESSION['user_email'])) {
      header('Location: login');
      exit();
   }
   
   
   // Validate app_no parameter
   if (isset($_GET['user_email'])) {
       $encryptedAppNo = sanitize_input($_GET['user_email']);
       $user_email = base64_decode($encryptedAppNo, true);
       if ($user_email === false) {
           error_log("Failed to decode app_no parameter: $encryptedAppNo");
           header('Location: login');
           exit();
       }
    
       $_SESSION['user_email'] = $user_email;

       $user_role = $_SESSION['user_role'];
       $passauth = base64_encode($user_email);
   } else {
       error_log("app_no parameter missing. Redirecting to login.php");
       header('Location: login');
       exit();
   }
   
   // Establish database connection
   $conn = new mysqli($servername, $username, $password, $database);
   
   // Check connection
   if ($conn->connect_error) {
       error_log("Connection failed: " . $conn->connect_error);
       die("Connection failed: " . $conn->connect_error);
   }
   
   // Retrieve application number from session
   if (isset($_SESSION['user_email'])) {
       $user_email = sanitize_input($_SESSION['user_email']);
   } else {
       error_log("Session app_no not set. Redirecting to login.php");
       header('Location: login');
       exit();
   }
   
   // Prepare SQL statement with parameter binding to prevent SQL injection
   $sql = "SELECT * FROM admin_users WHERE email = ?";
   $stmt = $conn->prepare($sql);
   $stmt->bind_param("s", $user_email);
   $stmt->execute();
   $result = $stmt->get_result();
   
   if ($result->num_rows > 0) {
       // Application number exists in database, fetch data securely
       $row = $result->fetch_assoc();
       $name = 'Admin'; // Sanitize output
   } else {
       header('Location: login');
       exit();
   }
   
$query = "SELECT DISTINCT title FROM trainings";
$result = $conn->query($query);

$titles = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $titles[] = $row['title'];
    }
}
// Get distinct locations
$query1 = "SELECT DISTINCT location FROM trainings";
$result1 = $conn->query($query1);

$locations = [];
if ($result1->num_rows > 0) {
    while ($row = $result1->fetch_assoc()) {
        $locations[] = $row['location'];
    }
}

   
// Fetch the count of mentors
$mentorCountQuery = "SELECT COUNT(*) as mentor_count FROM users WHERE role = 'mentor'";
$mentorResult = $conn->query($mentorCountQuery);
$mentorCount = $mentorResult->fetch_assoc()['mentor_count'];

// Fetch the count of candidates
$candidateCountQuery = "SELECT COUNT(*) as candidate_count FROM users WHERE role = 'candidate'";
$candidateResult = $conn->query($candidateCountQuery);
$candidateCount = $candidateResult->fetch_assoc()['candidate_count'];

// Fetch the count of applications
$applicationCountQuery = "SELECT COUNT(*) as application_count FROM userCourses";
$applicationResult = $conn->query($applicationCountQuery);
$applicationCount = $applicationResult->fetch_assoc()['application_count'];

// Fetch the count of trainings
$trainingCountQuery = "SELECT COUNT(*) as training_count FROM trainings";
$trainingResult = $conn->query($trainingCountQuery);
$trainingCount = $trainingResult->fetch_assoc()['training_count'];


// Fetch the count of IDs where is_course_completed == 0
$notCompletedCountQuery = "SELECT COUNT(*) as not_completed_count FROM userCourses WHERE is_course_completed = 0";
$notCompletedResult = $conn->query($notCompletedCountQuery);
$notCompletedCount = $notCompletedResult->fetch_assoc()['not_completed_count'];

// Fetch the count of unique user IDs
$uniqueUserCountQuery = "SELECT COUNT(DISTINCT userid) as unique_user_count FROM userCourses";
$uniqueUserResult = $conn->query($uniqueUserCountQuery);
$uniqueUserCount = $uniqueUserResult->fetch_assoc()['unique_user_count'];

// Fetch the count of IDs where is_course_completed == 1
$completedCountQuery = "SELECT COUNT(*) as completed_count FROM userCourses WHERE is_course_completed = 1";
$completedResult = $conn->query($completedCountQuery);
$completedCount = $completedResult->fetch_assoc()['completed_count'];

$totalResourcesQuery = "SELECT COUNT(*) as total_count FROM resources";
$totalResourcesResult = $conn->query($totalResourcesQuery);
$totalResourcesCount = $totalResourcesResult->fetch_assoc()['total_count'];

// Fetch the count of resources where type is 'Ebooks'
$ebooksCountQuery = "SELECT COUNT(*) as ebooks_count FROM resources WHERE type = 'Ebooks'";
$ebooksResult = $conn->query($ebooksCountQuery);
$ebooksCount = $ebooksResult->fetch_assoc()['ebooks_count'];

// Fetch the count of resources where type is 'articles'
$articlesCountQuery = "SELECT COUNT(*) as articles_count FROM resources WHERE type = 'articles'";
$articlesResult = $conn->query($articlesCountQuery);
$articlesCount = $articlesResult->fetch_assoc()['articles_count'];



// Fetch total course count
$totalCoursesQuery = "SELECT COUNT(*) as total FROM trainings";
$totalCoursesResult = $conn->query($totalCoursesQuery);
$totalCoursesRow = $totalCoursesResult->fetch_assoc();
$totalCoursesCount = $totalCoursesRow['total'];

// Fetch online course count
$onlineCoursesQuery = "SELECT COUNT(*) as online FROM trainings WHERE mode = 'online'";
$onlineCoursesResult = $conn->query($onlineCoursesQuery);
$onlineCoursesRow = $onlineCoursesResult->fetch_assoc();
$onlineCoursesCount = $onlineCoursesRow['online'];

// Fetch offline course count
$offlineCoursesQuery = "SELECT COUNT(*) as offline FROM trainings WHERE mode = 'offline'";
$offlineCoursesResult = $conn->query($offlineCoursesQuery);
$offlineCoursesRow = $offlineCoursesResult->fetch_assoc();
$offlineCoursesCount = $offlineCoursesRow['offline'];

// Fetch active courses count
$activeCoursesQuery = "SELECT COUNT(*) as active FROM trainings WHERE isCourse = 1";
$activeCoursesResult = $conn->query($activeCoursesQuery);
$activeCoursesRow = $activeCoursesResult->fetch_assoc();
$activeCoursesCount = $activeCoursesRow['active'];


// Fetch total members count
$totalMembersQuery = "SELECT COUNT(*) as total FROM users WHERE role = 'mentor' OR role = 'expert' OR role = 'investor'"; // Replace 'members' with your actual table name
$totalMembersResult = $conn->query($totalMembersQuery);
$totalMembersRow = $totalMembersResult->fetch_assoc();
$totalMembersCount = $totalMembersRow['total'];

// Fetch mentors count
$mentorsCountQuery = "SELECT COUNT(*) as mentors FROM users WHERE role = 'mentor'"; // Replace 'members' with your actual table name
$mentorsCountResult = $conn->query($mentorsCountQuery);
$mentorsCountRow = $mentorsCountResult->fetch_assoc();
$mentorsCount = $mentorsCountRow['mentors'];

// Fetch investors count
$investorsCountQuery = "SELECT COUNT(*) as investors FROM users WHERE role = 'investor'"; // Replace 'members' with your actual table name
$investorsCountResult = $conn->query($investorsCountQuery);
$investorsCountRow = $investorsCountResult->fetch_assoc();
$investorsCount = $investorsCountRow['investors'];

// Fetch experts count
$expertsCountQuery = "SELECT COUNT(*) as experts FROM users WHERE role = 'expert'"; // Replace 'members' with your actual table name
$expertsCountResult = $conn->query($expertsCountQuery);
$expertsCountRow = $expertsCountResult->fetch_assoc();
$expertsCount = $expertsCountRow['experts'];


  $mentorsQuery = "SELECT id, name FROM users WHERE role = 'mentor'";
    $mentorsResult = $conn->query($mentorsQuery);

    if ($mentorsResult->num_rows > 0) {
        $mentors = [];
        while ($row = $mentorsResult->fetch_assoc()) {
            $mentors[] = $row;
        }
    } else {
        $mentors = [];
    }

// Fetch all course data
$coursesQuery = "SELECT * FROM trainings";
$coursesResult = $conn->query($coursesQuery);

   $stmt->close();
   $conn->close();
   ?>
   
   <!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>EDIIMOB</title>
    <link rel="stylesheet" href="./static/vendors/feather/feather.css">
    <link rel="stylesheet" href="./static/vendors/ti-icons/css/themify-icons.css">
    <link rel="stylesheet" href="./static/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="./static/vendors/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="./static/vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="./static/css/loader.css">
    <link rel="stylesheet" href="./static/css/custom.css">
    <link rel="stylesheet" href="./static/vendors/ti-icons/css/themify-icons.css">
    <link rel="stylesheet" href="./static/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.2/css/dataTables.bootstrap.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.2/css/dataTables.dataTables.min.css">
    
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/3.0.2/css/responsive.bootstrap.css">
    <script src="./static/vendors/js/vendor.bundle.base.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/2.1.2/js/dataTables.js"></script>
    <script src="https://cdn.datatables.net/2.1.2/js/dataTables.bootstrap.js"></script>
    <script src="https://kit.fontawesome.com/5164f520d9.js" crossorigin="anonymous"></script>
    <script src="https://cdn.datatables.net/responsive/3.0.2/js/dataTables.responsive.js"></script>
    <script src="https://cdn.datatables.net/responsive/3.0.2/js/responsive.bootstrap.js"></script>
    <script>
$(document).ready(function() {
    var titles = <?php echo json_encode($titles); ?>;
    var trainingTitleDropdown = $('#trainingTitle');
    titles.forEach(function(title) {
        trainingTitleDropdown.append(new Option(title, title));
    });
});
</script>
<script>
$(document).ready(function() {
    // Populate locations
    var location = <?php echo json_encode($locations); ?>;
        var locationDropdown = $('#location');
        location.forEach(function(location) {
            locationDropdown.append(new Option(location, location));
        });
});
</script>

</head>
