<?php
if (session_status() == PHP_SESSION_NONE) {
   session_start();
}


?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>EDIIMOB</title>
    <!-- plugins:css -->
    <link rel="stylesheet" href="./static/vendors/feather/feather.css">
    <link rel="stylesheet" href="./static/vendors/ti-icons/css/themify-icons.css">
    <link rel="stylesheet" href="./static/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="./static/vendors/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="./static/vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="./static/css/style.css">
    <link rel="stylesheet" href="./static/css/loader2.css">

    <link rel="shortcut icon" href="./static/images/favicon.png" />
    <link href='https://unpkg.com/boxicons@2.1.2/css/boxicons.min.css' rel='stylesheet'>

    <style>
        #togglePassword{
            margin-top: 7px;
        }
        .passform {
        position: relative;
      }
      .eye-icon {
        position: absolute;
        right: 10px;

        top: 45%;
        transform: translateY(-50%);
        font-size: 18px;
        color: #8b8b8b;
        cursor: pointer;
      }
    </style>
     <script type="text/javascript">
    window.history.forward();
    function noBack() {
        window.history.forward();
    }
    window.onload = noBack;
    window.onpageshow = function(evt) {
        if (evt.persisted) noBack();
    };
    window.onunload = function() {
        null;
    };
</script>
  </head>
  <body>
    <div class="container-scroller">
   
  <div class="overlay" id="overlay">
    <div class="loader" id="loader"></div>
   </div>
      <div class="container-fluid page-body-wrapper full-page-wrapper">
        <!-- Remove 'active' class, this is just to show in Codepen thumbnail -->
   <div class="content-wrapper d-flex align-items-center auth px-0">
   <div class="toast">
          <div class="toast-content">
            <i class="fas fa-solid fa-check check"></i>
            <div class="message">
             
              <span class="text text-2">Your changes have been saved</span>
            </div>
          </div>
          <i class="fa-solid fa-xmark close"></i>
          <div class="progress"></div>
        </div>
          <div class="row w-100 mx-0">
          <div class="brand-logo1">
                  <img src="./static/images/tnediilogo.png" alt="logo">
                </div>
            <div class="col-lg-4 mx-auto">
              <div class="auth-form-light text-left py-5 px-4 px-sm-5">
              
                <h4>Login</h4>
                <h6 class="font-weight-light">EDII-TN Mobile App Admin Login</h6>
            
                <form  id="loginForm" class="pt-3">
                 
                  <div class="form-group">
                    <input type="email" class="form-control form-control-lg" id="InputEmail1" placeholder="Email">
                  </div>
               
                  <div class="form-group passform">
                    <input type="password" class="form-control form-control-lg" id="InputPassword1" placeholder="Password">
                    <i class='bx bx-hide eye-icon mt-2' id="togglePassword"></i>
                  </div>
                 
                  <div class="mt-3 d-grid gap-2">  
                    <button class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn" type="submit">Login</button>
                  
                  </div>
                 
                </form>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
      </div>
      <!-- page-body-wrapper ends -->
    </div>
  
    
  
    <script src="./static/vendors/js/vendor.bundle.base.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
      const togglePassword = document.getElementById('togglePassword');
      const passwordField = document.getElementById('InputPassword1');

      togglePassword.addEventListener('click', function () {
        const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', type);

        this.classList.toggle('bx-hide');
        this.classList.toggle('bx-show');
      });
    });

    $(document).ready(function () {
      $('#loginForm').on('submit', function (event) {
        event.preventDefault();
        const email = $('#InputEmail1').val().trim();
        const password = $('#InputPassword1').val().trim();
        $.ajax({
          url: 'config/api/log',
          type: 'POST',
          data: {
            email: email,
            password: password
          },
          success: function (response) {
            if (response.status === "success") {
              const encryptedAppNo = btoa(response.user_email);
              showLoaderAndRedirect(encryptedAppNo);
            } else {
              showAlert('This Invalid Credentials, Please Check');
            }
          },
          error: function () {
            showAlert('An error occurred. Please try again.');
          }
        });
      });

      function showLoaderAndRedirect(encryptedAppNo) {
        document.getElementById('overlay').style.display = 'flex';
        setTimeout(function () {
          window.location.href = `dash?user_email=${encryptedAppNo}`;
          document.getElementById('overlay').style.display = 'none';
        }, 5000);
      };

      function showAlert(message) {
        const toast = document.querySelector('.toast');
        const toastMessage = toast.querySelector('.toast .message .text.text-2');
        toastMessage.textContent = message;
        toast.classList.add('active');
        document.querySelector('.toast .progress').classList.add('active');

        setTimeout(() => {
          toast.classList.remove('active');
          document.querySelector('.toast .progress').classList.remove('active');
        }, 5000);
      }
    });
  </script>

  
    <script src="./static/js/off-canvas.js"></script>
    <script src="./static/js/template.js"></script>
    <script src="./static/js/settings.js"></script>
    <script src="./static/js/todolist.js"></script>
    <!-- endinject -->
  </body>
</html>