<?php require_once("controllers/layout/header.php") ?>

<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
         <!-- partial:partials/_sidebar.html -->
         <?php require_once("controllers/layout/sidebar.php") ?>
         <!-- partial -->
         <div class="main-panel">
            <div class="content-wrapper">
                
               <div class="toast">
                  <div class="toast-content">
                     <i class="fas fa-solid fa-check check"></i>
                     <div class="message">
                        <span class="text text-2">Your changes have been saved</span>
                     </div>
                  </div>
                  <i class="fa-solid fa-xmark close"></i>
                  <div class="progress"></div>
               </div>
               <div class="row">
                <!-- Modal HTML -->
                <div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="viewModalLabel">candidate Details</h5>
        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!-- Form to display student details -->
        <form id="studentDetailsForm">
          <div class="form-row row">
            <div class="form-group col-md-4">
              <label for="name">Name:</label>
              <input type="text" class="form-control" id="name" disabled>
            </div>
          
            <div class="form-group col-md-2 col-12">
              <label for="date_of_birth">Date of Birth:</label>
              <input type="text" class="form-control" id="date_of_birth" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="age">Age:</label>
              <input type="text" class="form-control" id="age" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="gender">Gender:</label>
              <input type="text" class="form-control" id="gender" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="role">Role:</label>
              <input type="text" class="form-control" id="role" disabled>
            </div>


            <div class="form-group col-md-3 col-12">
              <label for="email">Email:</label>
              <input type="email" class="form-control" id="email" disabled>
            </div>
            <div class="form-group col-md-3 col-12">
              <label for="phone">Phone Number:</label>
              <input type="text" class="form-control" id="phone" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="qualification">Qualification:</label>
              <input type="text" class="form-control" id="qualification" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="year_of_completion">Year of Completion:</label>
              <input type="text" class="form-control" id="year_of_completion" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="name_of_degree">Name of Degree:</label>
              <input type="text" class="form-control" id="name_of_degree" disabled>
            </div>


            <div class="form-group col-md-3 col-12">
              <label for="name_of_university">Name of University:</label>
              <input type="text" class="form-control" id="name_of_university" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="percentage_of_marks">Percentage of Marks:</label>
              <input type="text" class="form-control" id="percentage_of_marks" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="religion">Religion:</label>
              <input type="text" class="form-control" id="religion" disabled>
            </div>
            
            <div class="form-group col-md-3 col-12">
              <label for="community">Community:</label>
              <input type="text" class="form-control" id="community" disabled>
            </div>
          
            <div class="form-group col-md-2 col-12">
              <label for="differently_abled">Differently Abled:</label>
              <input type="text" class="form-control" id="differently_abled" disabled>
            </div>


             <div class="form-group col-md-3 col-12">
              <label for="father_name">Father's Name:</label>
              <input type="text" class="form-control" id="father_name" disabled>
            </div>
            <div class="form-group col-md-3 col-12">
              <label for="mother_name">Mother's Name:</label>
              <input type="text" class="form-control" id="mother_name" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="guardian_number">Guardian's Number:</label>
              <input type="text" class="form-control" id="guardian_number" disabled>
            </div>
            <div class="form-group col-md-4">
              <label for="address_of_communication">Address of Communication:</label>
              <input type="text" class="form-control" id="address_of_communication" disabled>
            </div>
       
            <div class="form-group col-md-5">
              <label for="permanent_address">Permanent Address:</label>
              <input type="text" class="form-control" id="permanent_address" disabled>
            </div>
            <div class="form-group col-md-2 col-12">
              <label for="location">Location:</label>
              <input type="text" class="form-control" id="location" disabled>
            </div>  
           
            <div class="form-group col-md-2 col-12">
              <label for="pincode">Pincode:</label>
              <input type="text" class="form-control" id="pincode" disabled>
            </div>
            <div class="form-group col-md-3 col-12">
              <label for="createdAt">Created At:</label>
              <input type="text" class="form-control" id="createdAt" disabled>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

                  <div class="col-md-12 col-12 grid-margin mx-auto">
                     <div class="row">
                        <div class="col-md-12 col-12 grid-margin transparent">
                           <div class="row">
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-tale">
                                    <div class="card-body">
                                       <p class="mb-4">Number of Application</p>
                                       <p class="fs-30 mb-2"><?php echo $applicationCount; ?></p>
                                       <p>All Courses Applications</p>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-dark-blue">
                                    <div class="card-body">
                                       <p class="mb-4">Course Completed</p>
                                       <p class="fs-30 mb-2"><?php echo $completedCount; ?></p>
                                       <p>Course Completed Users</p>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-light-blue">
                                    <div class="card-body">
                                       <p class="mb-4">Total Applicants</p>
                                       <p class="fs-30 mb-2"><?php echo $uniqueUserCount ; ?></p>
                                       <p>Course Registered Candidates</p>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-light-danger">
                                    <div class="card-body">
                                       <p class="mb-4">Active Candidates</p>
                                       <p class="fs-30 mb-2"><?php echo $notCompletedCount; ?></p>
                                       <p>On Learning Applicants</p>
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="filter-container">
  <div class="form-row row">
    <div class="form-group col-md-3">
      <label for="fromDate">From Date:</label>
      <input type="date" class="form-control" id="fromDate">
    </div>
    <div class="form-group col-md-3">
      <label for="toDate">To Date:</label>
      <input type="date" class="form-control" id="toDate">
    </div>
    <div class="form-group col-md-2">
      <label for="courseStatus">Course Status:</label>
      <select class="form-control" id="courseStatus">
        <option value="">All</option>
        <option value="completed">Completed</option>
        <option value="not_completed">Not Completed</option>
      </select>
    </div>
    <div class="form-group col-md-2">
      <label for="trainingTitle">Training Title:</label>
      <select class="form-control" id="trainingTitle">
        <option value="">All</option>
        <!-- Dynamically populate training titles here -->
      </select>
    </div>
    

    <div class="form-group col-md-2 mt-5">
    <button class="btn btn-primary" id="filterButton">Filter</button>
</div>
  </div>
</div>

                           <div class="row">
                            
                              <div class="col-md-12 col-lg-12 col-12 grid-margin">
                              <table id="appover" class="table table-striped table-bordered  nowrap" style="width:100%">
                                    <thead>
                                       <th>S.No</th>
                                       <th>View</th>
                                       <th>Candidate Name</th>
                                       <th>Training Code</th>
                                       <th>Training Title</th>
                                       <th>Course Completed</th>
                                       <th>Certificate Generated</th>
                                       <th>Phone Number</th>
                                       <th>Candidate Email</th>
                                       <th>Training Description</th>
                                       <th>Training Start Date</th>
                                       <th>Training End Date</th>
                                       <th>Payment Done</th>
                                       <th>Created At</th>
                                       </tr>
                                    </thead>
                                    <tbody></tbody>
                                 </table>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
 
   <script>
$(document).ready(function() {
    var dataTable = $('#appover').DataTable({
        processing: true,
        serverSide: false,  // Initially load all data
        responsive: true,
        ajax: {
            url: "config/api/appoverapi",  // Ensure correct URL
            type: "GET",
            data: function(d) {
                d.fromDate = $('#fromDate').val() || '';
                d.toDate = $('#toDate').val() || '';
                d.courseStatus = $('#courseStatus').val() || '';
                d.trainingTitle = $('#trainingTitle').val() || '';
            },
            dataSrc: function(json) {
                if(json.data) {
                    return json.data;  // Ensure the data field is accessed
                } else {
                    return [];
                }
            }
        },
        columns: [
            { "data": null, "render": function (data, type, row, meta) {
                return meta.row + 1; // Serial number
            }},
            { "data": null, "defaultContent": "<button class='view-btn btn btn-info'>View</button>" },
            { "data": "user_name" },
            { "data": "training_code" },
            { "data": "training_title" },
            { "data": "is_course_completed", "render": function (data) { return data == 1 ? 'Yes' : 'No'; }},
            { "data": "is_certificate_generated", "render": function (data) { return data == 1 ? 'Yes' : 'No'; }},
            { "data": "user_phonenumber" },
            { "data": "user_email" },
            { "data": "training_description" },
            { "data": "training_start_date" },
            { "data": "training_end_date" },
            { "data": "is_payment_done", "render": function (data) { return data == 1 ? 'Yes' : 'No'; }},
            { "data": "userCourses_createdAt" }
        ]
    });

    // Event listener for the filter button
    $('#filterButton').click(function() {
        dataTable.settings()[0].ajax.data = function(d) {
            d.fromDate = $('#fromDate').val();
            d.toDate = $('#toDate').val();
            d.courseStatus = $('#courseStatus').val();
            d.trainingTitle = $('#trainingTitle').val();
        };
        dataTable.settings()[0].ajax.url = "config/api/appoverapi";
        dataTable.settings()[0].ajax.type = "GET";
        dataTable.settings()[0].serverSide = true;
        dataTable.ajax.reload();
    });

    // Event listener for the view button
    $('#appover tbody').on('click', '.view-btn', function () {
        var data = dataTable.row($(this).parents('tr')).data();
        showModal(data);
    });
});

function showModal(data) {
    $('#name').val(data.user_name || '');
    $('#email').val(data.user_email || '');
    $('#phone').val(data.user_phonenumber || '');
    $('#role').val(data.user_role || '');
    $('#location').val(data.user_location || '');
    $('#qualification').val(data.user_qualification || '');
    $('#date_of_birth').val(data.user_date_of_birth || '');
    $('#age').val(data.user_age || '');
    $('#gender').val(data.user_gender || '');
    $('#permanent_address').val(data.user_permanent_address || '');
    $('#community').val(data.user_community || '');
    $('#religion').val(data.user_religion || '');
    $('#differently_abled').val(data.user_differently_abled || '');
    $('#name_of_university').val(data.user_name_of_university || '');
    $('#name_of_degree').val(data.user_name_of_degree || '');
    $('#year_of_completion').val(data.user_year_of_completion || '');
    $('#percentage_of_marks').val(data.user_percentage_of_marks || '');
    $('#father_name').val(data.user_father_name || '');
    $('#mother_name').val(data.user_mother_name || '');
    $('#guardian_number').val(data.user_guardian_number || '');
    $('#address_of_communication').val(data.user_address_of_communication || '');
    $('#pincode').val(data.user_pincode || '');
    $('#createdAt').val(data.userCourses_createdAt || '');

    $('#viewModal').modal('show');
}


</script>

    <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>