<?php require_once("controllers/layout/header.php") ?>
<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
         <!-- partial:partials/_sidebar.html -->
         <?php require_once("controllers/layout/sidebar.php") ?>
         <!-- partial -->
         <div class="main-panel">
            <div class="content-wrapper">
               <div class="toast">
                  <div class="toast-content">
                     <i class="fas fa-solid fa-check check"></i>
                     <div class="message">
                        <span class="text text-2">Your changes have been saved</span>
                     </div>
                  </div>
                  <i class="fa-solid fa-xmark close"></i>
                  <div class="progress"></div>
               </div>
               <div class="row">
                
                  <div class="col-md-12 col-12 grid-margin mx-auto">
                     <div class="row">
                        <div class="col-md-12 col-12 grid-margin transparent">
                           <div class="row">
                             
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-dark-blue">
                                    <div class="card-body">
                                       <p class="mb-4">Total Course</p>
                                       <p class="fs-30 mb-2"><?php echo $totalCoursesCount; ?></p>
                                       <p>Total Courses Count</p>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-light-danger">
                                    <div class="card-body">
                                       <p class="mb-4">Online Courses</p>
                                       <p class="fs-30 mb-2"><?php echo $onlineCoursesCount; ?></p>
                                       <p>online trainings</p>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-light-danger">
                                    <div class="card-body">
                                       <p class="mb-4">Offline Courses</p>
                                       <p class="fs-30 mb-2"><?php echo $offlineCoursesCount; ?></p>
                                       <p>Offline Trainings</p>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-light-danger">
                                    <div class="card-body">
                                       <p class="mb-4">Active Courses</p>
                                       <p class="fs-30 mb-2"><?php echo $activeCoursesCount; ?></p>
                                       <p>On Learning Applicants</p>
                                    </div>
                                 </div>
                              </div>
                              
                           </div>
                           <div class="filter-container">
                              <div class="form-row row">
                                 <div class="form-group col-md-3">
                                       <label for="fromDate">From Date:</label>
                                       <input type="date" class="form-control" id="fromDate">
                                 </div>
                                 <div class="form-group col-md-3">
                                       <label for="toDate">To Date:</label>
                                       <input type="date" class="form-control" id="toDate">
                                 </div>
                                 <div class="form-group col-md-2">
                                       <label for="courseStatus">Course Status:</label>
                                       <select class="form-control" id="courseStatus">
                                          <option value="">All</option>
                                          <option value="completed">Active</option>
                                          <option value="not_completed">Not Active</option>
                                       </select>
                                 </div>
                                 <div class="form-group col-md-2">
                                    <label for="location">Location:</label>
                                    <select class="form-control" id="location">
                                       <option value="">All</option>
                                  
                                    </select>
                                 </div>
                                 <div class="form-group col-md-2 mt-5">
                                       <button class="btn btn-primary w-100" id="filterButton">Filter</button>
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                           <div class="col-md-12">
                                    <table id="coursesTable" class="table table-striped table-bordered  nowrap" style="width:100%">
                                    <thead>
                                          <tr>
                                             <th>S.No</th>
                                             <th>Title</th>
                                             <th>Description</th>
                                             <th>Code</th>
                                             <th>Is Course</th>
                                             <th>Mode</th>
                                             <th>Rating</th>
                                             <th>Start Date</th>
                                             <th>End Date</th>
                                             <th>Fee Amount</th>
                                             <th>Is Full Time</th>
                                             <th>Location</th>
                                             <th>Mentor ID</th>
                                             <th>Created At</th>
                                             <th>Updated At</th>
                                          </tr>
                                       </thead>
                                    </table>
                                </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
 
   <script>
   $(document).ready(function() {

        
    // Initialize DataTable
    var table = $('#coursesTable').DataTable({
        processing: true,
        serverSide: false,
        responsive: true,
        ajax: {
            url: "config/api/trainoverapi",
            type: "GET",
            data: function(d) {
                // Add filter parameters to the request
                d.fromDate = $('#fromDate').val();
                d.toDate = $('#toDate').val();
                d.courseStatus = $('#courseStatus').val();
                d.trainingTitle = $('#trainingTitle').val();
                d.location = $('#location').val();
            },
            dataSrc: function(json) {
                return json.data || [];
            }
        },
        columns: [
            { "data": null, "render": function (data, type, row, meta) {
                return meta.row + 1; // Serial number
            }},
            { "data": "training_title" },
            { "data": "training_description" },
            { "data": "training_code" },
            { "data": "training_isCourse", "render": function (data) { return data == 1 ? 'Yes' : 'No'; }},
            { "data": "training_mode" },
            { "data": "training_rating" },
            { "data": "training_start_date" },
            { "data": "training_end_date" },
            { "data": "training_fee_amount" },
            { "data": "training_is_fullTime", "render": function (data) { return data == 1 ? 'Yes' : 'No'; }},
            { "data": "training_location" },
            { "data": "training_mentorId" },
            { "data": "training_createdAt" },
            { "data": "training_updatedAt" }
        ]
    });

    // Filter button click event
    $('#filterButton').click(function() {
        table.ajax.reload(); // Reload table data with filters
    });
});

</script>
   <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>