<?php require_once("controllers/layout/header.php") ?>
<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
         <!-- partial:partials/_sidebar.html -->
         <?php require_once("controllers/layout/sidebar.php") ?>
         <!-- partial -->
         <div class="main-panel">
            <div class="content-wrapper">
               <div class="toast">
                  <div class="toast-content">
                     <i class="fas fa-solid fa-check check"></i>
                     <div class="message">
                        <span class="text text-2">Your changes have been saved</span>
                     </div>
                  </div>
                  <i class="fa-solid fa-xmark close"></i>
                  <div class="progress"></div>
               </div>
               <div class="row">
                  <div class="modal fade" id="addCourseModal" tabindex="-1" aria-labelledby="addCourseModalLabel" aria-hidden="true">
                     <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                           <div class="modal-header">
                              <h5 class="modal-title" id="addCourseModalLabel">Add New Course</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                           </div>
                           <div class="modal-body">
                              <form id="addCourseForm">
                                 <div class="row">
                                    <div class="col-md-4">
                                       <div class="mb-3">
                                          <label for="courseTitle" class="form-label">Title</label>
                                          <input type="text" class="form-control" id="courseTitle" name="title" required>
                                       </div>
                                    </div>
                                    <div class="col-md-4">
                                       <div class="mb-3">
                                          <label for="courseDescription" class="form-label">Description</label>
                                          <textarea class="form-control" id="courseDescription" name="description" required></textarea>
                                       </div>
                                    </div>
                                    <div class="col-md-4">
                                       <div class="mb-3">
                                          <label for="courseCode" class="form-label">Code</label>
                                          <input type="text" class="form-control" id="courseCode" name="code" required>
                                       </div>
                                    </div>
                                    <div class="col-md-6">
                                       <div class="mb-3">
                                          <label for="courseMode" class="form-label">Mode</label>
                                          <select class="form-control" id="courseMode" name="mode" required>
                                             <option value="online">Online</option>
                                             <option value="offline">Offline</option>
                                          </select>
                                       </div>
                                    </div>
                                    <div class="col-md-6">
                                       <div class="mb-3">
                                          <label for="courseFeeAmount" class="form-label">Fee Amount</label>
                                          <input type="number" class="form-control" id="courseFeeAmount" name="fee_amount" required>
                                       </div>
                                    </div>
                                    <div class="col-md-6">
                                       <div class="mb-3">
                                          <label for="courseStartDate" class="form-label">Start Date</label>
                                          <input type="date" class="form-control" id="courseStartDate" name="start_date" required>
                                       </div>
                                    </div>
                                    <div class="col-md-6">
                                       <div class="mb-3">
                                          <label for="courseEndDate" class="form-label">End Date</label>
                                          <input type="date" class="form-control" id="courseEndDate" name="end_date" required>
                                       </div>
                                    </div>
                                    <div class="col-md-6">
                                       <div class="mb-3">
                                          <label for="courseIsFullTime" class="form-label">Is Full Time</label>
                                          <select class="form-control" id="courseIsFullTime" name="is_fullTime" required>
                                             <option value="1">Yes</option>
                                             <option value="0">No</option>
                                          </select>
                                       </div>
                                    </div>
                                    <div class="col-md-6">
                                       <div class="mb-3">
                                          <label for="courseLocation" class="form-label">Location</label>
                                          <select class="form-control" id="courseLocation" name="location" required>
                                             <option value="" disabled selected>Select District</option>
                                             <!-- Tamil Nadu districts -->
                                             <option value="Ariyalur">Ariyalur</option>
                                             <option value="Chengalpattu">Chengalpattu</option>
                                             <option value="Chennai">Chennai</option>
                                             <option value="Coimbatore">Coimbatore</option>
                                             <option value="Cuddalore">Cuddalore</option>
                                             <option value="Dharmapuri">Dharmapuri</option>
                                             <option value="Dindigul">Dindigul</option>
                                             <option value="Erode">Erode</option>
                                             <option value="Kallakurichi">Kallakurichi</option>
                                             <option value="Kanchipuram">Kanchipuram</option>
                                             <option value="Kanyakumari">Kanyakumari</option>
                                             <option value="Karur">Karur</option>
                                             <option value="Krishnagiri">Krishnagiri</option>
                                             <option value="Madurai">Madurai</option>
                                             <option value="Nagapattinam">Nagapattinam</option>
                                             <option value="Namakkal">Namakkal</option>
                                             <option value="Nilgiris">Nilgiris</option>
                                             <option value="Perambalur">Perambalur</option>
                                             <option value="Pudukkottai">Pudukkottai</option>
                                             <option value="Ramanathapuram">Ramanathapuram</option>
                                             <option value="Ranipet">Ranipet</option>
                                             <option value="Salem">Salem</option>
                                             <option value="Sivaganga">Sivaganga</option>
                                             <option value="Tenkasi">Tenkasi</option>
                                             <option value="Thanjavur">Thanjavur</option>
                                             <option value="Theni">Theni</option>
                                             <option value="Thiruvallur">Thiruvallur</option>
                                             <option value="Thiruvarur">Thiruvarur</option>
                                             <option value="Tiruchirappalli">Tiruchirappalli</option>
                                             <option value="Tirunelveli">Tirunelveli</option>
                                             <option value="Tirupathur">Tirupathur</option>
                                             <option value="Tiruppur">Tiruppur</option>
                                             <option value="Tiruvannamalai">Tiruvannamalai</option>
                                             <option value="Vellore">Vellore</option>
                                             <option value="Viluppuram">Viluppuram</option>
                                             <option value="Virudhunagar">Virudhunagar</option>
                                          </select>
                                       </div>
                                    </div>
                                    <div class="col-md-6">
                                       <div class="mb-3">
                                           
                                          <label for="courseMentorId" class="form-label">Mentor ID</label>
                                          <select name="mentorId"  class="form-control"  id="courseMentorId">
            <?php foreach ($mentors as $mentor): ?>
                <option value="<?= $mentor['id']; ?>"><?= $mentor['name']; ?></option>
            <?php endforeach; ?>
        </select>
                                          
                                       </div>
                                    </div>
                                    <div class="col-md-6">
   <div class="mb-3">
      <label for="courseImage" class="form-label">Upload Image</label>
      <input type="file" class="form-control" id="courseImage" name="courseImage" accept="image/*">
   </div>
</div>

                                    <div class="text-end">
                                       <button type="submit" class="btn btn-primary">Add Course</button>
                                    </div>
                                 </div>
                              </form>
                           </div>
                        </div>
                     </div>
                  </div>
                  <!-- Edit Course Modal -->
                  <div class="modal fade" id="editCourseModal" tabindex="-1" aria-labelledby="editCourseModalLabel" aria-hidden="true">
                     <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                           <div class="modal-header">
                              <h5 class="modal-title" id="editCourseModalLabel">Edit Course</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                           </div>
                           <div class="modal-body">
                              <form id="editCourseForm" enctype="multipart/form-data">
                                 <input type="hidden" id="editCourseId" name="id">
                                 <div class="row">
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingTitle" class="form-label">Title</label>
                                       <input type="text" class="form-control" id="editTrainingTitle" name="title">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingDescription" class="form-label">Description</label>
                                       <textarea class="form-control" id="editTrainingDescription" name="description"></textarea>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingCode" class="form-label">Code</label>
                                       <input type="text" class="form-control" id="editTrainingCode" name="code">
                                    </div>
                                 </div>
                                 <div class="row">
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingMode" class="form-label">Mode</label>
                                       <select class="form-control" id="editTrainingMode" name="mode">
                                          <option value="online">Online</option>
                                          <option value="offline">Offline</option>
                                       </select>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingStartDate" class="form-label">Start Date</label>
                                       <input type="date" class="form-control" id="editTrainingStartDate" name="start_date">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingEndDate" class="form-label">End Date</label>
                                       <input type="date" class="form-control" id="editTrainingEndDate" name="end_date">
                                    </div>
                                 </div>
                                 <div class="row">
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingFeeAmount" class="form-label">Fee Amount</label>
                                       <input type="number" class="form-control" id="editTrainingFeeAmount" name="fee_amount">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingIsFullTime" class="form-label">Full Time</label>
                                       <select class="form-control" id="editTrainingIsFullTime" name="is_fullTime">
                                          <option value="1">Yes</option>
                                          <option value="0">No</option>
                                       </select>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                       <label for="editTrainingLocation" class="form-label">Location</label>
                                       <select class="form-control" id="editTrainingLocation" name="location" required>
                                          <option value="" disabled selected>Select District</option>
                                          <!-- Tamil Nadu districts -->
                                          <option value="Ariyalur">Ariyalur</option>
                                          <option value="Chengalpattu">Chengalpattu</option>
                                          <option value="Chennai">Chennai</option>
                                          <option value="Coimbatore">Coimbatore</option>
                                          <option value="Cuddalore">Cuddalore</option>
                                          <option value="Dharmapuri">Dharmapuri</option>
                                          <option value="Dindigul">Dindigul</option>
                                          <option value="Erode">Erode</option>
                                          <option value="Kallakurichi">Kallakurichi</option>
                                          <option value="Kanchipuram">Kanchipuram</option>
                                          <option value="Kanyakumari">Kanyakumari</option>
                                          <option value="Karur">Karur</option>
                                          <option value="Krishnagiri">Krishnagiri</option>
                                          <option value="Madurai">Madurai</option>
                                          <option value="Nagapattinam">Nagapattinam</option>
                                          <option value="Namakkal">Namakkal</option>
                                          <option value="Nilgiris">Nilgiris</option>
                                          <option value="Perambalur">Perambalur</option>
                                          <option value="Pudukkottai">Pudukkottai</option>
                                          <option value="Ramanathapuram">Ramanathapuram</option>
                                          <option value="Ranipet">Ranipet</option>
                                          <option value="Salem">Salem</option>
                                          <option value="Sivaganga">Sivaganga</option>
                                          <option value="Tenkasi">Tenkasi</option>
                                          <option value="Thanjavur">Thanjavur</option>
                                          <option value="Theni">Theni</option>
                                          <option value="Thiruvallur">Thiruvallur</option>
                                          <option value="Thiruvarur">Thiruvarur</option>
                                          <option value="Tiruchirappalli">Tiruchirappalli</option>
                                          <option value="Tirunelveli">Tirunelveli</option>
                                          <option value="Tirupathur">Tirupathur</option>
                                          <option value="Tiruppur">Tiruppur</option>
                                          <option value="Tiruvannamalai">Tiruvannamalai</option>
                                          <option value="Vellore">Vellore</option>
                                          <option value="Viluppuram">Viluppuram</option>
                                          <option value="Virudhunagar">Virudhunagar</option>
                                       </select>
                                    </div>
                                 </div>
                                 
                                 <div class="mb-3">
                                    <label for="editTrainingMentorId" class="form-label">Mentor ID</label>
                                      <select name="mentorId" class="form-control" id="editTrainingMentorId">
            <?php foreach ($mentors as $mentor): ?>
                <option value="<?= $mentor['id']; ?>"><?= $mentor['name']; ?></option>
            <?php endforeach; ?>
        </select>
                                 
                                 </div>
                                 <div class="mb-3">
    <label for="editTrainingImage" class="form-label">Image</label>
    <input type="file" class="form-control" id="editTrainingImage" name="image">
</div>

                    <button type="button" class="btn btn-primary" id="updateeditButton">Update</button>
                </form>
            </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="col-md-12 col-12 grid-margin mx-auto">
                  <div class="row">
                     <div class="col-md-12 col-12 grid-margin transparent">
                        <div class="row">
                           <div class="form-group col-md-2 mt-5">
                              <button class="btn btn-primary w-100" id="addCourseButton">Add Course</button>
                           </div>
                        </div>
                        <div class="row">
                           <div class="col-md-12">
                              <table id="coursesTable" class="table table-striped table-bordered  nowrap" style="width:100%">
                                 <thead>
                                    <tr>
                                       <th>S.No</th>
                                       <th>Title</th>
                                       <th>Description</th>
                                       <th>Code</th>
                                       <th>Mode</th>
                                       <th>Edit </th>
                                       <th>Delete </th>
                                       <th>Start Date</th>
                                       <th>End Date</th>
                                       <th>Fee Amount</th>
                                       <th>Is Full Time</th>
                                       <th>Location</th>
                                       <th>Mentor ID</th>
                                    </tr>
                                 </thead>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   </div>
   <script>
      $(document).ready(function() {
          // Show the modal when the "Add Course" button is clicked
          $('#addCourseButton').click(function() {
              $('#addCourseModal').modal('show');
          });
      
          // Handle form submission
           $('#addCourseForm').submit(function(event) {
        event.preventDefault();
        
        var formData = new FormData(this);
        
              $.ajax({
                  url: 'config/api/appcourseapi', // URL for your PHP script that handles adding the course
                  type: 'POST',
                  data: formData,
                  contentType: false,
                  processData: false,
                  success: function(response) {
                      // Close the modal
                      $('#addCourseModal').modal('hide');
                      
                      // Reload the DataTable
                      $('#coursesTable').DataTable().ajax.reload();
      
                      // Optionally, show a success message
                      showAlert('Course added successfully!');
                  },
                  error: function() {
                      // Optionally, show an error message
                      showAlert('Error adding course.');
                  }
              });
              function showAlert(message) {
              const toast = document.querySelector('.toast');
              const toastMessage = toast.querySelector('.toast .message .text.text-2');
              toastMessage.textContent = message;
              toast.classList.add('active');
              document.querySelector('.toast .progress').classList.add('active');
              var inputs = document.querySelectorAll('#addCourseForm input, #addCourseForm select, #addCourseForm textarea');
        inputs.forEach(function(input) {
          input.value = '';
        });
      
        // Reset the select elements to their default option
        var selects = document.querySelectorAll('#addCourseForm select');
        selects.forEach(function(select) {
          select.selectedIndex = 0; // or set to a specific default value
        });
              setTimeout(() => {
                toast.classList.remove('active');
                document.querySelector('.toast .progress').classList.remove('active');
              }, 5000);
            }
          });
          
      });
   </script>
   <script>$(document).ready(function() {
      // Initialize DataTable
      var table = $('#coursesTable').DataTable({
          processing: true,
          serverSide: false,
          responsive: true,
          ajax: {
              url: "config/api/trainoverapi",
              type: "GET",
              dataSrc: function(json) {
                  return json.data || [];
              }
          },
          columns: [
            
              { "data": null, "render": function (data, type, row, meta) {
                  return meta.row + 1; // Serial number
              }},
             
           
              { "data": "training_title" },
             { 
        "data": "training_description",
        "render": function(data, type, row, meta) {
            if (type === 'display' && data) {
                let words = data.split(' ');
                let shortDescription = words.slice(0, 6).join(' '); // Get first 8 words
                if (words.length > 6) {
                    shortDescription += '...'; // Add ellipsis if there are more words
                }
                return shortDescription;
            }
            return data;
        }
    },
              { "data": "training_code" },
              { "data": "training_mode", "render": function (data) { return data == 1 ? 'Offline' : 'Online'; }},
              { 
                  "data": null,
                  "defaultContent": '<button class="btn btn-success editButton">Edit</button>',
                  "orderable": false
              },
              { 
                  "data": null,
                  "defaultContent": '<button class="btn btn-primary deleteButton">Delete</button>',
                  "orderable": false
              },
              { "data": "training_start_date" },
              { "data": "training_end_date" },
              { "data": "training_fee_amount" },
              { "data": "training_is_fullTime", "render": function (data) { return data == 1 ? 'Yes' : 'No'; }},
              { "data": "training_location" },
              { "data": "training_mentorId" }
          ]
      });
      
      // Handle Edit button click
      $('#coursesTable tbody').on('click', '.editButton', function() {
          var data = table.row($(this).parents('tr')).data();
          $('#editCourseId').val(data.training_id); // Set hidden field
          $('#editTrainingTitle').val(data.training_title);
          $('#editTrainingDescription').val(data.training_description);
          $('#editTrainingCode').val(data.training_code);
          $('#editTrainingMode').val(data.training_mode); // Ensure the correct display logic
          $('#editTrainingStartDate').val(data.training_start_date);
          $('#editTrainingEndDate').val(data.training_end_date);
          $('#editTrainingFeeAmount').val(data.training_fee_amount);
          $('#editTrainingIsFullTime').val(data.training_is_fullTime); // Ensure the correct display logic
          $('#editTrainingLocation').val(data.training_location);
          $('#editTrainingMentorId').val(data.training_mentorId);
          $('#editCourseModal').modal('show');
      });
      
     $('#updateeditButton').on('click', function() {
    var formData = new FormData($('#editCourseForm')[0]);
    console.log(formData);
    $.ajax({
        url: 'config/api/upcourseapi',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function(response) {
            console.log('Response:', response); // Debugging
            $('#editCourseModal').modal('hide');
            table.ajax.reload();
            showAlert('Course updated successfully!');
        },
        error: function(xhr, status, error) {
            console.error('Update failed:', status, error); // Debugging
            showAlert('Failed to update course.');
        }
    });
});

      // Handle Delete button click
      $('#coursesTable').on('click', '.deleteButton', function() {
         var data = table.row($(this).parents('tr')).data();
         console.log(data);
          if (confirm('Are you sure you want to delete this course?')) {
              $.ajax({
                  url: 'config/api/delcourseapi',
                  type: 'POST',
                  data: { id: data.training_id},
                  success: function(response) {
                      table.ajax.reload();
                      showAlert('Course deleted successfully!');
                  },
                  error: function(xhr, status, error) {
                      console.error('Delete failed:', status, error); // Debugging
                      showAlert('Error deleting course.');
                  }
              });
          }
      });
      
      // Function to show alert
      function showAlert(message) {
          const toast = document.querySelector('.toast');
          const toastMessage = toast.querySelector('.toast .message .text.text-2');
          toastMessage.textContent = message;
          toast.classList.add('active');
          document.querySelector('.toast .progress').classList.add('active');
          setTimeout(() => {
              toast.classList.remove('active');
              document.querySelector('.toast .progress').classList.remove('active');
          }, 5000);
      }
      });
   </script>
   <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>