<?php require_once("controllers/layout/header.php") ?>

<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
         <!-- partial:partials/_sidebar.html -->
         <?php require_once("controllers/layout/sidebar.php") ?>
         <!-- partial -->
         <div class="main-panel">
            <div class="content-wrapper">
                
               <div class="toast">
                  <div class="toast-content">
                     <i class="fas fa-solid fa-check check"></i>
                     <div class="message">
                        <span class="text text-2">Your changes have been saved</span>
                     </div>
                  </div>
                  <i class="fa-solid fa-xmark close"></i>
                  <div class="progress"></div>
               </div>
               <div class="row">
             <!-- Modal HTML -->
<div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="viewModalLabel">Candidate Rating & Description</h5>
        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!-- Section to display rating and description -->
        <div class="form-group">
          <label for="starRating">Rating:</label>
          <div id="starRating"></div> <!-- Placeholder for star icons -->
        </div>
        <div class="form-group">
          <label for="description">Description:</label>
          <textarea class="form-control" id="description" rows="3" disabled></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>


                  <div class="col-md-12 col-12 grid-margin mx-auto">
                     <div class="row">
                        <div class="col-md-12 col-12 grid-margin transparent">
                           <div class="row">
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-tale">
                                    <div class="card-body">
                                       <p class="mb-4">Number of Application</p>
                                       <p class="fs-30 mb-2"><?php echo $applicationCount; ?></p>
                                       <p>All Courses Applications</p>
                                    </div>
                                 </div>
                              </div>
                             
                              
                          
                           </div>
                       <div class="filter-container">
  <div class="form-row row">
    <div class="form-group col-md-3">
      <label for="fromDate">From Date:</label>
      <input type="date" class="form-control" id="fromDate">
    </div>
    <div class="form-group col-md-3">
      <label for="toDate">To Date:</label>
      <input type="date" class="form-control" id="toDate">
    </div>
    <div class="form-group col-md-2">
      <label for="rating">Rating:</label>
      <select class="form-control" id="rating">
        <option value="">All</option>
        <option value="1">1</option>
        <option value="2">2</option>
        <option value="3">3</option>
        <option value="4">4</option>
        <option value="5">5</option>
      </select>
    </div>
    <div class="form-group col-md-2 mt-5">
      <button class="btn btn-primary" id="filterButton">Filter</button>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-12 col-lg-12 col-12 grid-margin">
    <table id="appover" class="table table-striped table-bordered nowrap" style="width:100%">
      <thead>
        <tr>
          <th>S.No</th>
          <th>View</th>
          <th>Candidate Name</th>
          <th>Phone Number</th>
          <th>Candidate Email</th>
          <th>Rating</th>
          <th>Description</th>
          <th>Created At</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>

<script>
$(document).ready(function() {
    var dataTable = $('#appover').DataTable({
        processing: true,
        serverSide: true, // Server-side processing is required for filtering
        responsive: true,
        ajax: {
            url: "config/api/feedbackapi",  // Your API URL
            type: "GET",
            data: function(d) {
                d.fromDate = $('#fromDate').val() || '';
                d.toDate = $('#toDate').val() || '';
                d.rating = $('#rating').val() || '';
            },
            dataSrc: function(json) {
                return json.data || [];
            }
        },
        columns: [
            { "data": null, "render": function (data, type, row, meta) {
                return meta.row + 1; // Serial number
            }},
            { "data": null, "defaultContent": "<button class='view-btn btn btn-info'>View</button>" },
            { "data": "user_name" },
            { "data": "user_phonenumber" },
            { "data": "user_email" },
            { "data": "feedback_rating" },
            { "data": "feedback_description" },
            { "data": "feedback_createdAt" }
        ]
    });

    // Apply filters on button click
    $('#filterButton').on('click', function() {
        dataTable.ajax.reload(); // Reload the table data with new filters
    });

    // Event listener for the view button
    $('#appover tbody').on('click', '.view-btn', function () {
        var data = dataTable.row($(this).parents('tr')).data();
        showModal(data);
    });
});

function showModal(data) {
    const rating = data.feedback_rating || 0;
    const description = data.feedback_description || '';

    // Generate star icons based on the rating
    let starsHtml = '';
    for (let i = 1; i <= 5; i++) {
        if (i <= rating) {
            starsHtml += '<i class="fas fa-star text-warning"></i>'; // Filled star
        } else {
            starsHtml += '<i class="far fa-star text-warning"></i>'; // Empty star
        }
    }

    $('#starRating').html(starsHtml);
    $('#description').val(description);

    $('#viewModal').modal('show');
}


</script>


    <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>