<?php require_once("controllers/layout/header.php") ?>
<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
         <!-- partial:partials/_sidebar.html -->
         <?php require_once("controllers/layout/sidebar.php") ?>
         <!-- partial -->
         <div class="main-panel">
            <div class="content-wrapper">
               <div class="toast">
                  <div class="toast-content">
                     <i class="fas fa-solid fa-check check"></i>
                     <div class="message">
                        <span class="text text-2">Your changes have been saved</span>
                     </div>
                  </div>
                  <i class="fa-solid fa-xmark close"></i>
                  <div class="progress"></div>
               </div>
               <div class="row">
                  <!-- Modal HTML -->
                 <!-- Add Resource Modal HTML -->
<!-- Add Resource Modal HTML -->
<div class="modal fade" id="addResourceModal" tabindex="-1" role="dialog" aria-labelledby="addResourceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addResourceModalLabel">Add New Resource</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Form to add a new resource -->
                <form id="addResourceForm" enctype="multipart/form-data">
                    <div class="form-row row">
                        <div class="form-group col-md-6">
                            <label for="resourceName">Name:</label>
                            <input type="text" class="form-control" id="resourceName" name="name" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="resourceContent">Content:</label>
                            <input type="text" class="form-control" id="resourceContent" name="content" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="resourceType">Type:</label>
                            <select class="form-control" id="resourceType" name="type" required>
                                <option value="">Select Type</option>
                                <option value="Ebooks">Ebooks</option>
                                <option value="articles">Articles</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="resourceFile">File:</label>
                            <input type="file" class="form-control" id="resourceFile" name="file" required>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="saveResourceButton">Save</button>
            </div>
        </div>
    </div>
</div>


                  <div class="col-md-12 col-12 grid-margin mx-auto">
                     <div class="row">
                        <div class="col-md-12 col-12 grid-margin transparent">
                           <div class="row">
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-dark-blue">
                                    <div class="card-body">
                                       <p class="mb-4">Total Resources</p>
                                       <p class="fs-30 mb-2"><?php echo $totalResourcesCount; ?></p>
                                       <p>Resourses Count</p>
                                    </div>
                                 </div>
                              </div>
                            
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-light-danger">
                                    <div class="card-body">
                                       <p class="mb-4">Total Articles</p>
                                       <p class="fs-30 mb-2"><?php echo $articlesCount; ?></p>
                                       <p>On Articles Uploaded</p>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-light-danger">
                                    <div class="card-body">
                                       <p class="mb-4">Total Ebooks</p>
                                       <p class="fs-30 mb-2"><?php echo $ebooksCount; ?></p>
                                       <p>On Ebooks Uploaded</p>
                                    </div>
                                 </div>
                              </div>
                          
    <div class="col-md-3">
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addResourceModal">Add Resource</button>
    </div>


                           </div>
                           </div>
                        
                           <div class="filter-container">
                              <div class="form-row row">
                            
                            
                                 <div class="form-group col-md-3">
                                    <label for="fromDateFilter">From Date:</label>
                                    <input type="date" class="form-control"  id="fromDateFilter">
                                </div>
                                 <div class="form-group col-md-3">         
                                    <label for="toDateFilter">To Date:</label>
                                    <input type="date" class="form-control"  id="toDateFilter">
                                 </div>
                              
                                 <div class="form-group col-md-2 mt-5">
                                    <button class="btn btn-primary w-100" id="applyFilters">Filter</button>
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                              <div class="col-md-12 col-lg-12 col-12 grid-margin">
                              <table id="resourcesTable" class="table table-striped table-bordered  nowrap" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Content</th>
                                            <th>Type</th>
                                            <th>Download</th>
                                            <th>Created At</th>
                                        </tr>
                                    </thead>
                                </table>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <script>
        $(document).ready(function() {
            var table = $('#resourcesTable').DataTable({
                processing: true,
              serverSide: false,  // Initially load all data
              responsive: true,
                ajax: {
                    url: "config/api/resourceapi",
                    type: "GET",
                    data: function(d) {
                        d.name = $('#nameFilter').val();
                        d.type = $('#typeFilter').val();
                        d.fromDate = $('#fromDateFilter').val();
                        d.toDate = $('#toDateFilter').val();
                    }
                },
                columns: [
                    { "data": "id" },
                    { "data": "name" },
                    { "data": "content" },
                    { "data": "type" },
                    { 
                        "data": "path",
                        "render": function(data, type, row, meta) {
                            return '<a href="' + data + '" class="btn btn-primary" target="_blank">Download</a>';
                        }
                    },
                    { "data": "createdAt" }
                ]
            });

            $('#applyFilters').on('click', function() {
                table.ajax.reload();
            });
        });
    </script>
<script>
    $(document).ready(function() {
        $('#saveResourceButton').on('click', function() {
            var formData = new FormData($('#addResourceForm')[0]);
            $.ajax({
                url: 'config/api/addresapi',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    // Close the modal
                    $('#addResourceModal').modal('hide');
                    // Reload the table data
                    $('#resourcesTable').DataTable().ajax.reload();
                    // Optionally, show a success message
                    showAlert('Resource added successfully!');
                },
                error: function() {
                    showAlert('Failed to add resource.');
                }
            });
        });
        function showAlert(message) {
        const toast = document.querySelector('.toast');
        const toastMessage = toast.querySelector('.toast .message .text.text-2');
        toastMessage.textContent = message;
        toast.classList.add('active');
        document.querySelector('.toast .progress').classList.add('active');

        setTimeout(() => {
          toast.classList.remove('active');
          document.querySelector('.toast .progress').classList.remove('active');
        }, 5000);
      }
});
</script>


   <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>