<?php require_once("controllers/layout/header.php") ?>
<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
         <!-- partial:partials/_sidebar.html -->
         <?php require_once("controllers/layout/sidebar.php") ?>
         <!-- partial -->
         <div class="main-panel">
            <div class="content-wrapper">
               <div class="toast">
                  <div class="toast-content">
                     <i class="fas fa-solid fa-check check"></i>
                     <div class="message">
                        <span class="text text-2">Your changes have been saved</span>
                     </div>
                  </div>
                  <i class="fa-solid fa-xmark close"></i>
                  <div class="progress"></div>
               </div>
               <div class="row">
                  <!-- Modal HTML -->
                 <!-- Add Resource Modal HTML -->
<!-- Add Resource Modal HTML -->
<div class="modal fade" id="addResourceModal" tabindex="-1" role="dialog" aria-labelledby="addResourceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addResourceModalLabel">Add New Resource</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Form to add a new resource -->
                <form id="addResourceForm" enctype="multipart/form-data">
                    <div class="form-row row">
                        <div class="form-group col-md-6">
                            <label for="resourceName">Name:</label>
                            <input type="text" class="form-control" id="resourceName" name="name" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="resourceContent">Content:</label>
                            <input type="text" class="form-control" id="resourceContent" name="content" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="resourceType">Type:</label>
                            <select class="form-control" id="resourceType" name="type" required>
                                <option value="">Select Type</option>
                                <option value="Ebooks">Ebooks</option>
                                <option value="articles">Articles</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="resourceFile">File:</label>
                            <input type="file" class="form-control" id="resourceFile" name="file" required>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="saveResourceButton">Save</button>
            </div>
        </div>
    </div>
</div>
<!-- Edit Resource Modal HTML -->
<div class="modal fade" id="editResourceModal" tabindex="-1" role="dialog" aria-labelledby="editResourceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editResourceModalLabel">Edit Resource</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Form to edit a resource -->
                <form id="editResourceForm" enctype="multipart/form-data">
                    <input type="hidden" id="editResourceId" name="id">
                    <div class="form-row row">
                        <div class="form-group col-md-6">
                            <label for="editResourceName">Name:</label>
                            <input type="text" class="form-control" id="editResourceName" name="name" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="editResourceContent">Content:</label>
                            <input type="text" class="form-control" id="editResourceContent" name="content" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="editResourceType">Type:</label>
                            <select class="form-control" id="editResourceType" name="type" required>
                                <option value="">Select Type</option>
                                <option value="Ebooks">Ebooks</option>
                                <option value="articles">Articles</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="editResourceFile">File:</label>
                            <input type="file" class="form-control" id="editResourceFile" name="file">
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="updateResourceButton">Update</button>
            </div>
        </div>
    </div>
</div>


                  <div class="col-md-12 col-12 grid-margin mx-auto">
                     <div class="row">
                        <div class="col-md-12 col-12 grid-margin transparent">
                           <div class="row">
                                <div class="col-md-3">
                                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addResourceModal">Add Resource </button>
                                </div>
                           </div>
                        </div>
                        
                           <div class="filter-container">
                              <div class="form-row row">
                                 <div class="form-group col-md-3">
                                    <label for="fromDateFilter">From Date:</label>
                                    <input type="date" class="form-control"  id="fromDateFilter">
                                </div>
                                 <div class="form-group col-md-3">         
                                    <label for="toDateFilter">To Date:</label>
                                    <input type="date" class="form-control"  id="toDateFilter">
                                 </div>
                              
                                 <div class="form-group col-md-2 mt-5">
                                    <button class="btn btn-primary w-100" id="applyFilters">Filter</button>
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                              <div class="col-md-12 col-lg-12 col-12 grid-margin">
                              <table id="resourcesTable" class="display" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Content</th>
                                            <th>Type</th>
                                            <th>Created At</th>
                                            <th>PDF</th>
                                            <th>Edit</th>
                                        </tr>
                                    </thead>
                                </table>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <script>
        $(document).ready(function() {
            var table = $('#resourcesTable').DataTable({
                processing: true,
              serverSide: false,  // Initially load all data
              responsive: true,
                ajax: {
                    url: "config/api/resourceapi",
                    type: "GET",
                    data: function(d) {
                        d.name = $('#nameFilter').val();
                        d.type = $('#typeFilter').val();
                        d.fromDate = $('#fromDateFilter').val();
                        d.toDate = $('#toDateFilter').val();
                    }
                },
                columns: [
    { "data": "id" },
    { "data": "name" },
    { "data": "content" },
    { "data": "type" },
   
    { "data": "createdAt" },
    { 
                        "data": "path",
                        "render": function(data, type, row, meta) {
                            return '<a href="' + data + '" class="btn btn-primary" target="_blank">Download</a>';
                        }
                    },
    { 
        "data": null,
        "defaultContent": '<button class="btn btn-primary editButton">Edit</button>',
        "orderable": false
    }
]

});

$('#resourcesTable tbody').on('click', '.editButton', function() {
    var data = table.row($(this).parents('tr')).data();
    $('#editResourceId').val(data.id);
    $('#editResourceName').val(data.name);
    $('#editResourceContent').val(data.content);
    $('#editResourceType').val(data.type);
    $('#editResourceModal').modal('show');
});

$('#applyFilters').on('click', function() {
    table.ajax.reload();
});
});
    </script>
<script>
    $(document).ready(function() {
        $('#saveResourceButton').on('click', function() {
            var formData = new FormData($('#addResourceForm')[0]);
            $.ajax({
                url: 'config/api/addresapi',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    // Close the modal
                    $('#addResourceModal').modal('hide');
                    // Reload the table data
                    $('#resourcesTable').DataTable().ajax.reload();
                    // Optionally, show a success message
                    alert('Resource added successfully!');
                },
                error: function() {
                    alert('Failed to add resource.');
                }
            });
        });
  
        $('#updateResourceButton').on('click', function() {
        var formData = new FormData($('#editResourceForm')[0]);
        $.ajax({
            url: 'config/api/upresapi',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                $('#editResourceModal').modal('hide');
                $('#resourcesTable').DataTable().ajax.reload();
                showAlert('Resource updated successfully!');
            },
            error: function() {
               showAlert('Failed to update resource.');
            }
        });
    });
    function showAlert(message) {
        const toast = document.querySelector('.toast');
        const toastMessage = toast.querySelector('.toast .message .text.text-2');
        toastMessage.textContent = message;
        toast.classList.add('active');
        document.querySelector('.toast .progress').classList.add('active');

        setTimeout(() => {
          toast.classList.remove('active');
          document.querySelector('.toast .progress').classList.remove('active');
        }, 5000);
      }
});
</script>


   <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>