<?php require_once("controllers/layout/header.php") ?>
<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
         <!-- partial:partials/_sidebar.html -->
         <?php require_once("controllers/layout/sidebar.php") ?>
         <!-- partial -->
         <div class="main-panel">
            <div class="content-wrapper">
               <div class="toast">
                  <div class="toast-content">
                     <i class="fas fa-solid fa-check check"></i>
                     <div class="message">
                        <span class="text text-2">Your changes have been saved</span>
                     </div>
                  </div>
                  <i class="fa-solid fa-xmark close"></i>
                  <div class="progress"></div>
               </div>
               <div class="row">
                  <!-- Edit Member Modal -->
<div class="modal fade" id="editMemberModal" tabindex="-1" role="dialog" aria-labelledby="editMemberModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editMemberModalLabel">Edit Member</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editMemberForm">
                    <input type="hidden" id="editMemberId" name="id">
                    <div class="form-row row">
                        <div class="form-group col-md-6">
                            <label for="editName">Name:</label>
                            <input type="text" class="form-control" id="editName" name="name" required>
                        </div>
                        <div class="form-group col-md-6 col-12">
                            <label for="editRole">Role:</label>
                            <select class="form-control" id="editRole" name="roleadd" required>
                                <option value="mentor">Mentor</option>
                                <option value="expert">Expert</option>
                                <option value="investor">Investor</option>
                            </select>
                        </div>
                        <div class="form-group col-md-6 col-12">
                            <label for="editEmail">Email:</label>
                            <input type="email" class="form-control" id="editEmail" name="email" required>
                        </div>
                        <div class="form-group col-md-6 col-12">
                            <label for="editPhone">Phone Number:</label>
                            <input type="text" class="form-control" id="editPhone" name="phone" required>
                        </div>
                        <div class="form-group col-md-6 col-12">
                            <label for="editQualification">Qualification:</label>
                            <select class="form-control" id="editQualification" name="qualification" required>
                                <!-- Add the same qualification options as in the add form -->
                                <option value="B.A">B.A</option>
                                <option value="B.Sc">B.Sc</option>
                                <option value="B.Com">B.Com</option>
                                <option value="B.E">B.E</option>
                                <option value="B.Tech">B.Tech</option>
                                <option value="M.A">M.A</option>
                                <option value="M.Sc">M.Sc</option>
                                <option value="M.Com">M.Com</option>
                                <option value="M.E">M.E</option>
                                <option value="M.Tech">M.Tech</option>
                                <!-- Add more degree options as needed -->
                            </select>
                        </div>
                        <div class="form-group col-md-6 col-12">
                            <label for="editLocation">Location:</label>
                            <select class="form-control" id="editLocation" name="location" required>
                                <!-- Add the same district options as in the add form -->
                                <option value="Ariyalur">Ariyalur</option>
                                <option value="Chengalpattu">Chengalpattu</option>
                                <option value="Chennai">Chennai</option>
                                <option value="Coimbatore">Coimbatore</option>
                                <option value="Cuddalore">Cuddalore</option>
                                <option value="Dharmapuri">Dharmapuri</option>
                                <option value="Dindigul">Dindigul</option>
                                <option value="Erode">Erode</option>
                                <option value="Kallakurichi">Kallakurichi</option>
                                <option value="Kancheepuram">Kancheepuram</option>
                                <option value="Karur">Karur</option>
                                <option value="Krishnagiri">Krishnagiri</option>
                                <option value="Madurai">Madurai</option>
                                <option value="Nagapattinam">Nagapattinam</option>
                                <option value="Namakkal">Namakkal</option>
                                <option value="Nilgiris">Nilgiris</option>
                                <option value="Perambalur">Perambalur</option>
                                <option value="Pudukkottai">Pudukkottai</option>
                                <option value="Ramanathapuram">Ramanathapuram</option>
                                <option value="Ranipet">Ranipet</option>
                                <option value="Salem">Salem</option>
                                <option value="Sivagangai">Sivagangai</option>
                                <option value="Tenkasi">Tenkasi</option>
                                <option value="Thanjavur">Thanjavur</option>
                                <option value="Theni">Theni</option>
                                <option value="Thoothukudi">Thoothukudi</option>
                                <option value="Tiruchirappalli">Tiruchirappalli</option>
                                <option value="Tirunelveli">Tirunelveli</option>
                                <option value="Tirupathur">Tirupathur</option>
                                <option value="Tiruppur">Tiruppur</option>
                                <option value="Tiruvallur">Tiruvallur</option>
                                <option value="Tiruvannamalai">Tiruvannamalai</option>
                                <option value="Tiruvarur">Tiruvarur</option>
                                <option value="Vellore">Vellore</option>
                                <option value="Viluppuram">Viluppuram</option>
                                <option value="Virudhunagar">Virudhunagar</option>
                                <!-- Add more districts as needed -->
                            </select>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </form>
            </div>
        </div>
    </div>
</div>

                  <div class="modal fade" id="addMemberModal" tabindex="-1" role="dialog" aria-labelledby="addMemberModalLabel" aria-hidden="true">
                     <div class="modal-dialog  modal-dialog-centered" role="document">
                        <div class="modal-content">
                           <div class="modal-header">
                              <h5 class="modal-title" id="addMemberModalLabel">Add New Member</h5>
                              <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                              </button>
                           </div>
                           <div class="modal-body">
                              <form id="addMemberForm">
                                 <div class="form-row row">
                                    <div class="form-group col-md-6">
                                       <label for="name">Name:</label>
                                       <input type="text" class="form-control" id="name" name="name" required>
                                    </div>
                                    <div class="form-group col-md-6 col-12">
                                       <label for="role">Role:</label>
                                       <select class="form-control" id="roleadd" name="roleadd" required>
                                          <option value="mentor">Mentor</option>
                                          <option value="expert">Expert</option>
                                          <option value="investor">Investor</option>
                                       </select>
                                    </div>
                                    <div class="form-group col-md-6 col-12">
                                       <label for="email">Email:</label>
                                       <input type="email" class="form-control" id="email" name="email" required>
                                    </div>
                                    <div class="form-group col-md-6 col-12">
                                       <label for="phone">Phone Number:</label>
                                       <input type="text" class="form-control" id="phone" name="phone" required>
                                    </div>
                                    <div class="form-group col-md-6 col-12">
                                    <label for="qualification">Qualification:</label>
                                    <select class="form-control" id="qualification" name="qualification" required>
                                       <option value="B.A">B.A</option>
                                       <option value="B.Sc">B.Sc</option>
                                       <option value="B.Com">B.Com</option>
                                       <option value="B.E">B.E</option>
                                       <option value="B.Tech">B.Tech</option>
                                       <option value="M.A">M.A</option>
                                       <option value="M.Sc">M.Sc</option>
                                       <option value="M.Com">M.Com</option>
                                       <option value="M.E">M.E</option>
                                       <option value="M.Tech">M.Tech</option>
                                       <!-- Add more degree options as needed -->
                                    </select>
                              </div>
                              <div class="form-group col-md-6 col-12">
            <label for="location">Location:</label>
            <select class="form-control" id="location" name="location" required>
                <option value="Ariyalur">Ariyalur</option>
                <option value="Chengalpattu">Chengalpattu</option>
                <option value="Chennai">Chennai</option>
                <option value="Coimbatore">Coimbatore</option>
                <option value="Cuddalore">Cuddalore</option>
                <option value="Dharmapuri">Dharmapuri</option>
                <option value="Dindigul">Dindigul</option>
                <option value="Erode">Erode</option>
                <option value="Kallakurichi">Kallakurichi</option>
                <option value="Kancheepuram">Kancheepuram</option>
                <option value="Karur">Karur</option>
                <option value="Krishnagiri">Krishnagiri</option>
                <option value="Madurai">Madurai</option>
                <option value="Nagapattinam">Nagapattinam</option>
                <option value="Namakkal">Namakkal</option>
                <option value="Nilgiris">Nilgiris</option>
                <option value="Perambalur">Perambalur</option>
                <option value="Pudukkottai">Pudukkottai</option>
                <option value="Ramanathapuram">Ramanathapuram</option>
                <option value="Ranipet">Ranipet</option>
                <option value="Salem">Salem</option>
                <option value="Sivagangai">Sivagangai</option>
                <option value="Tenkasi">Tenkasi</option>
                <option value="Thanjavur">Thanjavur</option>
                <option value="Theni">Theni</option>
                <option value="Thoothukudi">Thoothukudi</option>
                <option value="Tiruchirappalli">Tiruchirappalli</option>
                <option value="Tirunelveli">Tirunelveli</option>
                <option value="Tirupathur">Tirupathur</option>
                <option value="Tiruppur">Tiruppur</option>
                <option value="Tiruvallur">Tiruvallur</option>
                <option value="Tiruvannamalai">Tiruvannamalai</option>
                <option value="Tiruvarur">Tiruvarur</option>
                <option value="Vellore">Vellore</option>
                <option value="Viluppuram">Viluppuram</option>
                <option value="Virudhunagar">Virudhunagar</option>
                <!-- Add more districts as needed -->
            </select>
        </div>
                                 </div>
                                 <button type="submit" class="btn btn-primary">Submit</button>
                              </form>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="col-md-12 col-12 grid-margin mx-auto">
                     <div class="row">
                        <div class="col-md-12 col-12 grid-margin transparent">
                           <div class="row">
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <button class="btn btn-success w-100" data-bs-toggle="modal" data-bs-target="#addMemberModal">Add Members</button>
                              </div>
                           </div>
                        </div>
                        <div class="filter-container">
                           <div class="form-row row">
                              <div class="form-group col-md-2">
                                 <label for="rolestate">Filter by role: </label>
                                 <select class="form-control role-select" id="rolestate">
                                    <option value="" default>All</option>
                                    <option value="mentor">Mentor</option>
                                    <option value="expert">Expert</option>
                                    <option value="investor">Investor</option>
                                 </select>
                              </div>
                              <div class="form-group col-md-2 mt-5">
                                 <button class="btn btn-primary w-100" id="filterButton">Filter</button>
                              </div>
                           </div>
                        </div>
                        <div class="row">
                           <div class="col-md-12 col-lg-12 col-12 grid-margin">
                              <table id="userTable" class="table table-striped table-bordered  nowrap" style="width:100%">
                                 <thead>
                                    <tr>
                                       <th>ID</th>
                                       <th>Name</th>
                                       <th>Role</th>
                                       <th>Email</th>
                                       <th>Phone Number</th>
                                       <th>Qualification</th>
                                       <th>Location</th>
                                    </tr>
                                 </thead>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   </div>
   <script>
    $(document).ready(function() {
    $('#addMemberForm').submit(function(event) {
        event.preventDefault();
        var formData = $(this).serialize();
        
        $.ajax({
            url: 'config/api/addmenapi',
            type: 'POST',
            data: formData,
            success: function(response) {
                $('#addMemberModal').modal('hide');
                $('#addMemberForm')[0].reset();
                $('#userTable').DataTable().ajax.reload();
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            }
        });
    });
    
    var table = $('#userTable').DataTable({
        processing: true,
        serverSide: false,
        responsive: true,
        ajax: {
            url: "config/api/mentoverapi",
            type: "GET",
            dataSrc: 'data'
        },
        columns: [
            { data: "id" },
            { data: "name" },
            { data: "role" },
            { data: "email" },
            { data: "phonenumber" },
            { data: "qualification" },
            { data: "location" },
            {
                data: null,
                defaultContent: '<button class="btn btn-warning edit-btn">Edit</button> <button class="btn btn-danger delete-btn">Delete</button>',
                orderable: false
            }
        ]
    });

    $('#userTable tbody').on('click', '.edit-btn', function() {
        var data = table.row($(this).parents('tr')).data();
        $('#editMemberId').val(data.id);
        $('#editName').val(data.name);
        $('#editRole').val(data.role);
        $('#editEmail').val(data.email);
        $('#editPhone').val(data.phonenumber);
        $('#editQualification').val(data.qualification);
        $('#editLocation').val(data.location);
        $('#editMemberModal').modal('show');
    });

    $('#editMemberForm').submit(function(event) {
        event.preventDefault();
        var formData = $(this).serialize();
        
        $.ajax({
            url: 'config/api/editmenapi',
            type: 'POST',
            data: formData,
            success: function(response) {
                $('#editMemberModal').modal('hide');
                $('#editMemberForm')[0].reset();
                $('#userTable').DataTable().ajax.reload();
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            }
        });
    });

    $('#userTable tbody').on('click', '.delete-btn', function() {
        var data = table.row($(this).parents('tr')).data();
        if (confirm("Are you sure you want to delete this member?")) {
            $.ajax({
                url: 'config/api/delmenapi',
                type: 'POST',
                data: { id: data.id },
                success: function(response) {
                    $('#userTable').DataTable().ajax.reload();
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        }
    });

    $('#filterButton').click(function() {
        table.settings()[0].ajax.data = function(d) {
            d.role = $('#rolestate').val();
        };
        table.ajax.reload();
    });
});


   </script>
   <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>