<?php require_once("controllers/layout/header.php") ?>
<body>
   <div class="container-scroller">
      <?php require_once("controllers/layout/navbar.php") ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
         <!-- partial:partials/_sidebar.html -->
         <?php require_once("controllers/layout/sidebar.php") ?>
         <!-- partial -->
         <div class="main-panel">
            <div class="content-wrapper">
               <div class="toast">
                  <div class="toast-content">
                     <i class="fas fa-solid fa-check check"></i>
                     <div class="message">
                        <span class="text text-2">Your changes have been saved</span>
                     </div>
                  </div>
                  <i class="fa-solid fa-xmark close"></i>
                  <div class="progress"></div>
               </div>
               <div class="row">
                  <!-- Modal HTML -->
                  <div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel" aria-hidden="true">
                     <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                        <div class="modal-content">
                           <div class="modal-header">
                              <h5 class="modal-title" id="viewModalLabel">candidate Details</h5>
                              <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                              </button>
                           </div>
                           <div class="modal-body">
                              <!-- Form to display student details -->
                              <form id="studentDetailsForm">
                                 <div class="form-row row">
                                    <div class="form-group col-md-4">
                                       <label for="name">Name:</label>
                                       <input type="text" class="form-control" id="name" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="date_of_birth">Date of Birth:</label>
                                       <input type="text" class="form-control" id="date_of_birth" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="age">Age:</label>
                                       <input type="text" class="form-control" id="age" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="gender">Gender:</label>
                                       <input type="text" class="form-control" id="gender" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="role">Role:</label>
                                       <input type="text" class="form-control" id="role" disabled>
                                    </div>
                                    <div class="form-group col-md-3 col-12">
                                       <label for="email">Email:</label>
                                       <input type="email" class="form-control" id="email" disabled>
                                    </div>
                                    <div class="form-group col-md-3 col-12">
                                       <label for="phone">Phone Number:</label>
                                       <input type="text" class="form-control" id="phone" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="qualification">Qualification:</label>
                                       <input type="text" class="form-control" id="qualification" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="year_of_completion">Year of Completion:</label>
                                       <input type="text" class="form-control" id="year_of_completion" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="name_of_degree">Name of Degree:</label>
                                       <input type="text" class="form-control" id="name_of_degree" disabled>
                                    </div>
                                    <div class="form-group col-md-3 col-12">
                                       <label for="name_of_university">Name of University:</label>
                                       <input type="text" class="form-control" id="name_of_university" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="percentage_of_marks">Percentage of Marks:</label>
                                       <input type="text" class="form-control" id="percentage_of_marks" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="religion">Religion:</label>
                                       <input type="text" class="form-control" id="religion" disabled>
                                    </div>
                                    <div class="form-group col-md-3 col-12">
                                       <label for="community">Community:</label>
                                       <input type="text" class="form-control" id="community" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="differently_abled">Differently Abled:</label>
                                       <input type="text" class="form-control" id="differently_abled" disabled>
                                    </div>
                                    <div class="form-group col-md-3 col-12">
                                       <label for="father_name">Father's Name:</label>
                                       <input type="text" class="form-control" id="father_name" disabled>
                                    </div>
                                    <div class="form-group col-md-3 col-12">
                                       <label for="mother_name">Mother's Name:</label>
                                       <input type="text" class="form-control" id="mother_name" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="guardian_number">Guardian's Number:</label>
                                       <input type="text" class="form-control" id="guardian_number" disabled>
                                    </div>
                                    <div class="form-group col-md-4">
                                       <label for="address_of_communication">Address of Communication:</label>
                                       <input type="text" class="form-control" id="address_of_communication" disabled>
                                    </div>
                                    <div class="form-group col-md-5">
                                       <label for="permanent_address">Permanent Address:</label>
                                       <input type="text" class="form-control" id="permanent_address" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="location">Location:</label>
                                       <input type="text" class="form-control" id="location" disabled>
                                    </div>
                                    <div class="form-group col-md-2 col-12">
                                       <label for="pincode">Pincode:</label>
                                       <input type="text" class="form-control" id="pincode" disabled>
                                    </div>
                                    <div class="form-group col-md-3 col-12">
                                       <label for="createdAt">Created At:</label>
                                       <input type="text" class="form-control" id="createdAt" disabled>
                                    </div>
                                 </div>
                              </form>
                           </div>
                           <div class="modal-footer">
                              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="col-md-12 col-12 grid-margin mx-auto">
                     <div class="row">
                        <div class="col-md-12 col-12 grid-margin transparent">
                           <div class="row">
                             
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-dark-blue">
                                    <div class="card-body">
                                       <p class="mb-4">Total Members</p>
                                       <p class="fs-30 mb-2"><?php echo $totalMembersCount; ?></p>
                                       <p>Members Count</p>
                                    </div>
                                 </div>
                              </div>
                            
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                 <div class="card card-light-danger">
                                    <div class="card-body">
                                       <p class="mb-4">Total mentors</p>
                                       <p class="fs-30 mb-2"><?php echo $mentorsCount; ?></p>
                                       <p>Mentors Count</p>
                                    </div>
                                 </div>
                              </div>
                           
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                    <div class="card card-light-danger">
                                       <div class="card-body">
                                          <p class="mb-4">Total Experts</p>
                                          <p class="fs-30 mb-2"><?php echo $investorsCount; ?></p>
                                          <p>Experts Count</p>
                                       </div>
                                    </div>
                              </div>
                          
                              <div class="col-md-3 col-12 mb-4 stretch-card transparent">
                                    <div class="card card-light-danger">
                                       <div class="card-body">
                                          <p class="mb-4">Total Investors</p>
                                          <p class="fs-30 mb-2"><?php echo $expertsCount; ?></p>
                                          <p>Investors Count</p>
                                       </div>
                                    </div>
                              </div>
                          </div>
                          </div>
                           <div class="filter-container">
                              <div class="form-row row">
                              
                               
                                 <div class="form-group col-md-2">
                                 <label for="rolestate">Filter by role: </label>
                                 <select class="form-control role-select" id="rolestate">
                                 <option value="" default>All</option>
                                 <option value="mentor">Mentor</option>
                                 <option value="expert">Expert</option>
                                 <option value="investor">Investor</option>
                                </select>
                 
                                 </div>
                                
                                 <div class="form-group col-md-2 mt-5">
                                 <button class="btn btn-primary w-100" id="filterButton">Filter</button>
                                 </div>
                                 
                              </div>
                           </div>
                           <div class="row">
                              <div class="col-md-12 col-lg-12 col-12 grid-margin">
                                 <table id="userTable" class="table table-striped table-bordered  nowrap" style="width:100%">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Role</th>
                <th>Email</th>
                <th>Phone Number</th>
                <th>Qualification</th>
                <th>Location</th>
            </tr>
        </thead>
    </table>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
 
   <script>
       
       $(document).ready(function() {
       
        
            var table = $('#userTable').DataTable({
                processing: true,
                serverSide: false, // Enable server-side processing
                responsive: true,
                ajax: {
                    url: "config/api/mentoverapi",
                    type: "GET", // Use GET method
                    data: function(d) {
                     d.role = $('#role').val() || '';
                 
            },
            dataSrc: 'data' // Ensure data is retrieved from 'data' field in response
        },
                columns: [
                    { data: "id" },
                    { data: "name" },
                    { data: "role" },
                    { data: "email" },
                    { data: "phonenumber" },
                    { data: "qualification" },
                    { data: "location" }
                ]
            });
            // Event listener for the filter button
            $('#filterButton').click(function() {
               table.settings()[0].ajax.data = function(d) {
                        d.role = $('#rolestate').val();
                        
                  };
                  table.settings()[0].ajax.url = "config/api/mentoverapi";
                  table.settings()[0].ajax.type = "GET";
                  table.settings()[0].serverSide = true;
                  table.ajax.reload();
               });


            
        });
    </script>
  
   <script src="./static/vendors/chart.js/chart.umd.js"></script>
   <script src="./static/js/off-canvas.js"></script>
   <script src="./static/js/template.js"></script>
   <script src="./static/js/settings.js"></script>
   <script src="./static/js/todolist.js"></script>
   <script src="./static/js/jquery.cookie.js" type="text/javascript"></script>
   <script src="./static/js/dashboard.js"></script>
</body>
</html>