<?php
session_start(); // Start the session

require_once __DIR__.'/router.php';

// Function to check if user is authenticated
function isAuthenticated() {
    return isset($_SESSION['user_email']); // Check if user_id is set
}

// Landing Routes
any('/', 'controllers/login.php');
any('/login', 'controllers/login.php');

any('/logout', 'controllers/logout.php');



// Admin routes (protected)
if (isAuthenticated()) {
  
    any('/dash', 'controllers/dash/index.php');
    any('/reset', 'controllers/pages/settings/reset.php');
    any('/addusers', 'controllers/pages/settings/addusers.php');
    any('/appover', 'controllers/pages/appover/appover.php');
    any('/cand', 'controllers/pages/candidates/cand.php');
    any('/addcourse', 'controllers/pages/course/addcourse.php');
    any('/courseover', 'controllers/pages/course/courseover.php');
    any('/editcourse', 'controllers/pages/course/editcourse.php');
    any('/feedback', 'controllers/pages/feedback/feedback.php');
    any('/addres', 'controllers/pages/resource/addres.php');
    any('/editres', 'controllers/pages/resource/editres.php');
    any('/mentor', 'controllers/pages/users/mentor.php');
    any('/menadd', 'controllers/pages/users/menadd.php');

} 
    any('/config/api/addusers', 'config/api/addusers.php');
    any('/config/api/appoverapi', 'config/api/appoverapi.php');
    any('/config/api/candoverapi', 'config/api/candoverapi.php');
    any('/config/api/feedbackapi', 'config/api/feedbackover.php');

    any('/config/api/appcourseapi', 'config/api/addcourse.php');
    any('/config/api/delcourseapi', 'config/api/delcourse.php');
    any('/config/api/addmenapi', 'config/api/addmenapi.php');
    any('/config/api/editmenapi', 'config/api/editmenapi.php');
    any('/config/api/delmenapi', 'config/api/delmenapi.php');

    any('/config/api/mentoverapi', 'config/api/mentover.php');

    any('/config/api/upcourseapi', 'config/api/upcourse.php');
    any('/config/api/trainfilter', 'config/api/trainfilterapi.php');
    any('/config/api/resourceapi', 'config/api/resourceapi.php');
    any('/config/api/addresapi', 'config/api/addres.php');
    any('/config/api/upresapi', 'config/api/updateresapi.php');
    any('/config/api/trainoverapi', 'config/api/trainover.php');
    any('/config/api/reset', 'config/api/reset.php');
    any('/config/api/log', 'config/api/logapi.php');


    any('/config/db', 'config/db.php');

any('/config/dbclient', 'config/dbclient.php');

any('/404', 'controllers/404page.php');

// If the requested route is not found, display the 404 page
http_response_code(404);
include 'controllers/404page.php';
?>