<?php
require_once __DIR__.'/baseurl.php';

function get($route, $path_to_include)
{
    if ($_SERVER['REQUEST_METHOD'] == 'GET') {
        route($route, $path_to_include);
    }
}

function post($route, $path_to_include)
{
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        route($route, $path_to_include);
    }
}

function put($route, $path_to_include)
{
    if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
        route($route, $path_to_include);
    }
}

function delete($route, $path_to_include)
{
    if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
        route($route, $path_to_include);
    }
}

function any($route, $path_to_include)
{
    route($route, $path_to_include);
}

function route($route, $path_to_include)
{
    $callback = $path_to_include;
    if (!is_callable($callback)) {
        if (!strpos($path_to_include, '.php')) {
            $path_to_include .= '.php';
        }
    }

    // Set your base directory here
    $base_dir = BASE_DIR;

    $request_url = filter_var($_SERVER['REQUEST_URI'], FILTER_SANITIZE_URL);
    $request_url = rtrim($request_url, '/');
    $request_url = strtok($request_url, '?');

    // Remove the base directory from the request URL
    if (strpos($request_url, $base_dir) === 0) {
        $request_url = substr($request_url, strlen($base_dir));
    }

    $route_parts = explode('/', $route);
    $request_url_parts = explode('/', $request_url);
    array_shift($route_parts);
    array_shift($request_url_parts);

    if ($route_parts[0] == '' && count($request_url_parts) == 0) {
        // Callback function
        if (is_callable($callback)) {
            call_user_func_array($callback, []);
            exit();
        }
        include_once __DIR__ . "/$path_to_include";
        exit();
    }

    if (count($route_parts) != count($request_url_parts)) {
        return;
    }

    $parameters = [];
    for ($i = 0; $i < count($route_parts); $i++) {
        $route_part = $route_parts[$i];
        if (preg_match("/^[$]/", $route_part)) {
            $route_part = ltrim($route_part, '$');
            array_push($parameters, $request_url_parts[$i]);
            $$route_part = $request_url_parts[$i];
        } else if ($route_parts[$i] != $request_url_parts[$i]) {
            return;
        }
    }

    // Callback function
    if (is_callable($callback)) {
        call_user_func_array($callback, $parameters);
        exit();
    }

    include_once __DIR__ . "/$path_to_include";
    exit();
}

function out($text)
{
    echo htmlspecialchars($text);
}
